/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.searchparams;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import net.guerlab.commons.abstractslayout.ApplicationError;
import net.guerlab.commons.annotation.ValueCheck;
import net.guerlab.commons.annotation.ValueCheckType;
import net.guerlab.commons.searchparams.SearchParamsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value="\u62bd\u8c61\u901a\u7528\u641c\u7d22\u53c2\u6570\u5bf9\u8c61")
public abstract class AbstractSearchParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSearchParams.class);
    public static final String PAGE_ID = "pageId";
    public static final String PAGE_SIZE = "pageSize";
    public static final String PESSIMISTIC_LOCK = "pessimisticLock";
    @ApiModelProperty(value="\u5206\u9875ID", example="1", allowableValues="range[1, infinity]")
    @ValueCheck(value=ValueCheckType.GREATERZONE)
    protected int pageId = 1;
    @ApiModelProperty(value="\u5206\u9875\u5185\u5bb9\u6570\u91cf", example="10", allowableValues="range[1, infinity]")
    @ValueCheck(value=ValueCheckType.GREATERZONE)
    protected int pageSize = 10;
    @ApiModelProperty(hidden=true)
    @JsonIgnore
    protected boolean pessimisticLock = false;

    public final void setFindAll() {
        this.pageId = 1;
        this.pageSize = Integer.MAX_VALUE;
    }

    public final void setFindOne() {
        this.pageId = 1;
        this.pageSize = 1;
    }

    public final int getPageId() {
        return this.pageId;
    }

    public final void setPageId(int pageId) {
        this.pageId = pageId;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    public final void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public AbstractSearchParams withPessimisticLock() {
        this.pessimisticLock = true;
        return this;
    }

    public AbstractSearchParams withoutPessimisticLock() {
        this.pessimisticLock = false;
        return this;
    }

    public Map<String, Object> toMap() {
        return SearchParamsHelper.toMap(this);
    }

    public static <T extends AbstractSearchParams> T build(Class<T> clazz) {
        AbstractSearchParams searchParams = null;
        try {
            searchParams = (AbstractSearchParams)clazz.newInstance();
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            throw new ApplicationError(e);
        }
        return (T)searchParams;
    }

    public static <T extends AbstractSearchParams> T buildByFindAll(Class<T> clazz) {
        AbstractSearchParams searchParams = null;
        try {
            searchParams = (AbstractSearchParams)clazz.newInstance();
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            throw new ApplicationError(e);
        }
        searchParams.setFindAll();
        return (T)searchParams;
    }

    public static <T extends AbstractSearchParams> T buildByLock(Class<T> clazz) {
        AbstractSearchParams searchParams = null;
        try {
            searchParams = (AbstractSearchParams)clazz.newInstance();
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            throw new ApplicationError(e);
        }
        searchParams.withPessimisticLock();
        return (T)searchParams;
    }

    public static <T extends AbstractSearchParams> T buildByFindAllAndLock(Class<T> clazz) {
        AbstractSearchParams searchParams = null;
        try {
            searchParams = (AbstractSearchParams)clazz.newInstance();
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            throw new ApplicationError(e);
        }
        searchParams.setFindAll();
        searchParams.pessimisticLock = true;
        return (T)searchParams;
    }
}

