/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.searchparams;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.guerlab.commons.annotation.ValueCheck;
import net.guerlab.commons.dbpaging.DBPagingHelper;
import net.guerlab.commons.field.FieldHelper;
import net.guerlab.commons.searchparams.AbstractSearchParams;
import net.guerlab.commons.searchparams.SearchParamsHandler;
import net.guerlab.commons.searchparams.SearchParamsParseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchParamsHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchParamsHelper.class);
    private static final Predicate<Field> STATIC_FILTER = e -> e != null && !Modifier.isStatic(e.getModifiers());
    private static final int DEFAULT_EMPTY_MAP_SIZE = 4;

    private SearchParamsHelper() {
        throw new SecurityException();
    }

    public static Map<String, Object> toMap(AbstractSearchParams searchParams) {
        return SearchParamsHelper.toMap(searchParams, SearchParamsParseConfig.getGlobalInstance());
    }

    public static Map<String, Object> toMap(AbstractSearchParams searchParams, SearchParamsParseConfig config) {
        return searchParams == null ? SearchParamsHelper.todoNull() : SearchParamsHelper.todoNotNull(searchParams, config);
    }

    private static Map<String, Object> todoNull() {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        DBPagingHelper.pageSet(1L, DBPagingHelper.getGlobalPageSize(), params);
        LOGGER.debug("create default empty map -> {}", params);
        return params;
    }

    private static Map<String, Object> todoNotNull(AbstractSearchParams searchParams, SearchParamsParseConfig config) {
        List<Field> fields = FieldHelper.getFiledsWithFilter(searchParams.getClass(), STATIC_FILTER);
        HashMap<String, Object> params = new HashMap<String, Object>(fields.size() + 4);
        for (Field field : fields) {
            SearchParamsHelper.readFieldValus(field, params, searchParams, config);
        }
        DBPagingHelper.pageSet(searchParams.getPageId(), searchParams.getPageSize(), params);
        LOGGER.debug("create map -> {}", params);
        return params;
    }

    private static void readFieldValus(Field field, Map<String, Object> params, AbstractSearchParams searchParams, SearchParamsParseConfig config) {
        String name = field.getName();
        Object value = FieldHelper.get(searchParams, name);
        if (value == null) {
            return;
        }
        ValueCheck valueCheck = field.getAnnotation(ValueCheck.class);
        LOGGER.debug("read field[{}] values[{}, type : {}]", new Object[]{field, value, value.getClass()});
        SearchParamsParseConfig useConfig = config == null ? SearchParamsParseConfig.getGlobalInstance() : config;
        SearchParamsHandler handler = useConfig.getHandler(field.getType());
        if (handler != null) {
            handler.setValue(params, name, value, valueCheck);
        }
    }
}

