/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.searchparams;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.guerlab.commons.searchparams.SearchParamsHandler;
import net.guerlab.commons.searchparams.handler.BigDecimalHandler;
import net.guerlab.commons.searchparams.handler.CollectionHandler;
import net.guerlab.commons.searchparams.handler.DefaultHandler;
import net.guerlab.commons.searchparams.handler.NumberHandler;
import net.guerlab.commons.searchparams.handler.StringHandler;

public class SearchParamsParseConfig {
    private static final SearchParamsParseConfig GLOBAL = new SearchParamsParseConfig();
    private final Map<Type, SearchParamsHandler> handlers = new HashMap<Type, SearchParamsHandler>();
    private SearchParamsHandler defaultHandler = DefaultHandler.INSTANCE;

    public SearchParamsParseConfig() {
        this.handlers.put((Type)((Object)Byte.class), new NumberHandler());
        this.handlers.put(Byte.TYPE, new NumberHandler());
        this.handlers.put((Type)((Object)Short.class), new NumberHandler());
        this.handlers.put(Short.TYPE, new NumberHandler());
        this.handlers.put((Type)((Object)Integer.class), new NumberHandler());
        this.handlers.put(Integer.TYPE, new NumberHandler());
        this.handlers.put((Type)((Object)Long.class), new NumberHandler());
        this.handlers.put(Long.TYPE, new NumberHandler());
        this.handlers.put((Type)((Object)Float.class), new NumberHandler());
        this.handlers.put(Float.TYPE, new NumberHandler());
        this.handlers.put((Type)((Object)Double.class), new NumberHandler());
        this.handlers.put(Double.TYPE, new NumberHandler());
        this.handlers.put((Type)((Object)BigDecimal.class), new BigDecimalHandler());
        this.handlers.put((Type)((Object)String.class), new StringHandler());
        this.handlers.put((Type)((Object)Collection.class), new CollectionHandler());
    }

    public static SearchParamsParseConfig getGlobalInstance() {
        return GLOBAL;
    }

    public void setDefaultHandler(SearchParamsHandler handler) {
        this.defaultHandler = handler;
    }

    public void addHandler(Type type, SearchParamsHandler handler) {
        if (type != null && handler != null) {
            this.handlers.put(type, handler);
        }
    }

    public SearchParamsHandler getHandler(Type type) {
        SearchParamsHandler handler = this.handlers.get(type);
        if (handler != null) {
            return handler;
        }
        if (!(type instanceof Class)) {
            return this.defaultHandler;
        }
        Class clazz = (Class)type;
        if (clazz.isEnum()) {
            handler = this.handlers.get(Enum.class);
        } else if (Collection.class.isAssignableFrom(clazz)) {
            handler = this.handlers.get(Collection.class);
        }
        return handler == null ? this.defaultHandler : handler;
    }
}

