/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.time;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.guerlab.commons.time.Formats;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeHelper.class);
    private static final Map<Integer, Formats> FORMATS = new HashMap<Integer, Formats>(Formats.values().length, 1.0f);

    private TimeHelper() {
        throw new SecurityException();
    }

    public static String format(Date date) {
        if (date == null) {
            return null;
        }
        return DateFormatUtils.format((Date)date, (String)Formats.STANDARD_DATE.getFormat());
    }

    public static String formatDate(LocalDateTime date) {
        if (date == null) {
            return null;
        }
        return date.format(DateTimeFormatter.ofPattern(Formats.SIMPLE_DATE.getFormat()));
    }

    public static String format(LocalDateTime date) {
        if (date == null) {
            return null;
        }
        return date.format(DateTimeFormatter.ofPattern(Formats.STANDARD_DATE.getFormat()));
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return DateFormatUtils.format((Date)date, (String)Formats.SIMPLE_DATE.getFormat());
    }

    public static Date parse(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        String text = string.trim();
        if (text.length() <= 0) {
            return null;
        }
        Date date = TimeHelper.numberParse(text);
        if (date != null) {
            return date;
        }
        return TimeHelper.textParase(text);
    }

    private static Date numberParse(String text) {
        try {
            long timestamp = Long.parseLong(text);
            return new Date(timestamp);
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static Date textParase(String text) {
        try {
            Formats format = FORMATS.get(text.length());
            if (format == null) {
                return null;
            }
            return DateUtils.parseDate((String)text.replace('T', ' ').replace('Z', ' '), (String[])new String[]{format.getFormat()});
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static LocalDateTime parseLocalDateTime(String string) {
        Date date = TimeHelper.parse(string);
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static boolean isSameDate(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        return DateUtils.isSameDay((Date)date1, (Date)date2);
    }

    static {
        for (Formats format : Formats.values()) {
            FORMATS.put(format.getLength(), format);
        }
    }
}

