/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.time.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;

public class LocalDateSerializer
extends JsonSerializer<LocalDate> {
    private static final LocalTime TIME = LocalTime.of(0, 0, 0, 0);

    public void serialize(LocalDate value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        LocalDateTime dateTime = LocalDateTime.of(value, TIME);
        long time = dateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        gen.writeNumber(time);
    }
}

