/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.time.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class LocalTimeSerializer
extends JsonSerializer<LocalTime> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");

    public void serialize(LocalTime localTime, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (localTime == null) {
            gen.writeNull();
            return;
        }
        String value = localTime.format(FORMATTER);
        gen.writeString(value);
    }
}

