/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return iterable == null || CollectionUtil.isEmpty(iterable.iterator());
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return iterator == null || !iterator.hasNext();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Enumeration<?> enumeration) {
        return enumeration == null || !enumeration.hasMoreElements();
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return !CollectionUtil.isEmpty(coll);
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return !CollectionUtil.isEmpty(iterable);
    }

    public static boolean isNotEmpty(Iterator<?> iterator) {
        return !CollectionUtil.isEmpty(iterator);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !CollectionUtil.isEmpty(map);
    }

    public static boolean isNotEmpty(Enumeration<?> enumeration) {
        return !CollectionUtil.isEmpty(enumeration);
    }

    public static boolean isBlank(Collection<?> coll) {
        return CollectionUtil.isEmpty(coll) || coll.stream().noneMatch(Objects::nonNull);
    }

    public static boolean isNotBlank(Collection<?> coll) {
        return !CollectionUtil.isBlank(coll);
    }

    public static <T> void forEach(Iterable<T> iterable, Consumer<? super T> action) {
        CollectionUtil.stream(iterable).forEach(action);
    }

    public static <T, K> Map<K, T> toMap(Collection<T> iterable, Function<T, K> keyMapper) {
        return CollectionUtil.toMap(iterable, keyMapper, Function.identity());
    }

    public static <T, K> Map<K, T> toMap(Collection<T> iterable, Function<T, K> keyMapper, Collection<Predicate<? super T>> filters) {
        return CollectionUtil.toMap(iterable, keyMapper, Function.identity(), filters);
    }

    public static <T, K, U> Map<K, U> toMap(Collection<T> iterable, Function<T, K> keyMapper, Function<T, U> valueMapper) {
        return CollectionUtil.toMap(iterable, keyMapper, valueMapper, CollectionUtil.throwingMerger(), HashMap::new);
    }

    public static <T, K, U> Map<K, U> toMap(Collection<T> iterable, Function<T, K> keyMapper, Function<T, U> valueMapper, Collection<Predicate<? super T>> filters) {
        return CollectionUtil.toMap(iterable, keyMapper, valueMapper, CollectionUtil.throwingMerger(), HashMap::new, filters);
    }

    public static <T, K, U, M extends Map<K, U>> Map<K, U> toMap(Iterable<T> iterable, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapSupplier) {
        return CollectionUtil.toMap(iterable, keyMapper, valueMapper, mergeFunction, mapSupplier, null);
    }

    public static <T, K, U, M extends Map<K, U>> Map<K, U> toMap(Iterable<T> iterable, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapSupplier, Collection<Predicate<? super T>> filters) {
        if (CollectionUtil.isEmpty(iterable)) {
            return Collections.emptyMap();
        }
        if (mergeFunction == null) {
            mergeFunction = CollectionUtil.throwingMerger();
        }
        return (Map)CollectionUtil.filters(CollectionUtil.stream(iterable), filters).collect(Collectors.toMap(keyMapper, valueMapper, mergeFunction, mapSupplier));
    }

    public static <I, O> List<O> toList(Iterable<I> iterable, Function<I, O> mapper) {
        return CollectionUtil.toList(iterable, mapper, null);
    }

    public static <I, O> List<O> toList(Iterable<I> iterable, Function<I, O> mapper, Collection<Predicate<? super O>> filters) {
        return CollectionUtil.toCollection(iterable, mapper, false, ArrayList::new, filters);
    }

    public static <I, O> List<O> toDistinctList(Iterable<I> iterable, Function<I, O> mapper) {
        return CollectionUtil.toDistinctList(iterable, mapper, null);
    }

    public static <I, O> List<O> toDistinctList(Iterable<I> iterable, Function<I, O> mapper, Collection<Predicate<? super O>> filters) {
        return CollectionUtil.toCollection(iterable, mapper, true, ArrayList::new, filters);
    }

    public static <I, O> Set<O> toSet(Iterable<I> iterable, Function<I, O> mapper) {
        return CollectionUtil.toSet(iterable, mapper, null);
    }

    public static <I, O> Set<O> toSet(Iterable<I> iterable, Function<I, O> mapper, Collection<Predicate<? super O>> filters) {
        return CollectionUtil.toCollection(iterable, mapper, false, HashSet::new, filters);
    }

    public static <I, O, C extends Collection<O>> C toCollection(Iterable<I> iterable, Function<I, O> mapper, Supplier<C> collectionFactory, Collection<Predicate<? super O>> filters) {
        return CollectionUtil.toCollection(iterable, mapper, false, collectionFactory, filters);
    }

    public static <I, O, C extends Collection<O>> C toCollection(Iterable<I> iterable, Function<I, O> mapper, boolean distinct, Supplier<C> collectionFactory, Collection<Predicate<? super O>> filters) {
        if (CollectionUtil.isEmpty(iterable)) {
            return (C)((Collection)collectionFactory.get());
        }
        Stream stream = CollectionUtil.filters(CollectionUtil.stream(iterable).map(mapper).filter(Objects::nonNull), filters);
        if (distinct) {
            stream = stream.distinct();
        }
        return (C)((Collection)stream.collect(Collectors.toCollection(collectionFactory)));
    }

    public static <K, E> Map<K, List<E>> group(Iterable<E> iterable, Function<E, K> mapper) {
        if (CollectionUtil.isEmpty(iterable)) {
            return Collections.emptyMap();
        }
        return CollectionUtil.stream(iterable).collect(Collectors.groupingBy(mapper));
    }

    public static <T> List<T> filters(Iterable<T> iterable, Collection<Predicate<? super T>> filters) {
        if (CollectionUtil.isEmpty(iterable)) {
            return new ArrayList();
        }
        return CollectionUtil.filters(CollectionUtil.stream(iterable).filter(Objects::nonNull), filters).collect(Collectors.toList());
    }

    public static <T> Stream<T> filters(Stream<T> stream, Collection<Predicate<? super T>> filters) {
        if (filters != null && !filters.isEmpty()) {
            for (Predicate<T> predicate : filters) {
                stream = stream.filter(predicate);
            }
        }
        return stream;
    }

    private static <E> Stream<E> stream(Iterable<E> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).filter(Objects::nonNull);
    }

    private static <V> BinaryOperator<V> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }
}

