/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.encrypt;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import net.guerlab.commons.encrypt.AuthCodeKey;
import net.guerlab.commons.encrypt.Rc4Helper;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthCodeHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthCodeHelper.class);
    public static final int DEFAULT_KEY_LENGTH = 4;

    private AuthCodeHelper() {
    }

    public static String encode(String str, String key, long expiry) {
        return AuthCodeHelper.toEncode(str, key, expiry, 4);
    }

    public static String encode(String str, String key, long expiry, int randomKeyLength) {
        return AuthCodeHelper.toEncode(str, key, expiry, randomKeyLength);
    }

    public static String decode(String str, String key) {
        return AuthCodeHelper.decode(str, key, 4);
    }

    public static String decode(String str, String key, int randomKeyLength) {
        return AuthCodeHelper.toDecode(str, key, randomKeyLength);
    }

    private static String toDecode(String str, String key, int randomKeyLength) {
        if (str == null) {
            throw new NullPointerException("str can not to be null");
        }
        long nowTime = System.currentTimeMillis() / 1000L;
        AuthCodeKey keys = new AuthCodeKey(key);
        String keyC = AuthCodeHelper.getKeyC(str, randomKeyLength);
        String cryptKey = keys.getKeyA() + DigestUtils.md5Hex((String)(keys.getKeyA() + keyC));
        String result = AuthCodeHelper.getResult(str, randomKeyLength, cryptKey);
        long time = AuthCodeHelper.getTime(result);
        if (time <= 0L && time < nowTime) {
            return "";
        }
        if (AuthCodeHelper.decodeCheck(result, keys)) {
            return result.substring(26);
        }
        result = AuthCodeHelper.getResult(str + "=", randomKeyLength, cryptKey);
        if (AuthCodeHelper.decodeCheck(result, keys)) {
            return result.substring(26);
        }
        result = AuthCodeHelper.getResult(str + "==", randomKeyLength, cryptKey);
        if (AuthCodeHelper.decodeCheck(result, keys)) {
            return result.substring(26);
        }
        return "";
    }

    private static String getKeyC(String nowStr, int randomKeyLength) {
        String keyC = "";
        if (randomKeyLength != 0) {
            keyC = nowStr.substring(0, randomKeyLength);
        }
        return keyC;
    }

    private static long getTime(String result) {
        try {
            return Long.parseLong(result.substring(0, 10));
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    private static String getResult(String nowStr, int randomKeyLength, String cryptKey) {
        byte[] temp = Base64.getDecoder().decode(nowStr.substring(randomKeyLength));
        return new String(Rc4Helper.encode(temp, cryptKey));
    }

    private static boolean decodeCheck(String result, AuthCodeKey keys) {
        String aString = DigestUtils.md5Hex((String)(result.substring(26) + keys.getKeyB()));
        String data = aString.substring(0, 16);
        return result.substring(10, 26).equals(data);
    }

    private static String toEncode(String str, String key, long expiry, int randomKeyLength) {
        if (str == null) {
            throw new NullPointerException("str can not to be null");
        }
        long timestamp = System.currentTimeMillis() / 1000L;
        AuthCodeKey keys = new AuthCodeKey(key);
        String keyC = "";
        if (randomKeyLength > 0) {
            String data = DigestUtils.md5Hex((String)String.valueOf(timestamp));
            keyC = data.substring(data.length() - randomKeyLength);
        }
        String cryptKey = keys.getKeyA() + DigestUtils.md5Hex((String)(keys.getKeyA() + keyC));
        String nowStr = str;
        nowStr = String.format("%010d", expiry > 0L ? timestamp + expiry : 0L) + DigestUtils.md5Hex((String)(nowStr + keys.getKeyB())).substring(0, 16) + nowStr;
        try {
            byte[] temp = Rc4Helper.encode(nowStr.getBytes(StandardCharsets.UTF_8), cryptKey);
            return keyC + Base64.getEncoder().encodeToString(temp);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

