/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.encrypt;

import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Rc4Helper {
    private static final Logger LOGGER = LoggerFactory.getLogger(Rc4Helper.class);

    private Rc4Helper() {
    }

    public static byte[] encode(byte[] input, String pass) {
        return Rc4Helper.encode(input, pass, Charset.defaultCharset().name());
    }

    public static byte[] encode(byte[] input, String pass, String charsetName) {
        if (charsetName == null) {
            throw new NullPointerException("charsetName can not be null");
        }
        if (input == null || pass == null) {
            return new byte[0];
        }
        try {
            byte[] output = new byte[input.length];
            byte[] mBox = Rc4Helper.getKey(pass.getBytes(charsetName));
            int i = 0;
            int j = 0;
            for (int offset = 0; offset < input.length; ++offset) {
                i = (i + 1) % mBox.length;
                j = (j + (mBox[i] + 256) % 256) % mBox.length;
                byte temp = mBox[i];
                mBox[i] = mBox[j];
                mBox[j] = temp;
                byte a = input[offset];
                byte b = mBox[(Rc4Helper.toInt(mBox[i]) + Rc4Helper.toInt(mBox[j])) % mBox.length];
                output[offset] = (byte)((long)a ^ (long)Rc4Helper.toInt(b));
            }
            return output;
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return new byte[0];
        }
    }

    private static byte[] getKey(byte[] pass) {
        int kLen = 256;
        byte[] mBox = new byte[kLen];
        for (int i = 0; i < kLen; ++i) {
            mBox[i] = (byte)i;
        }
        int j = 0;
        for (int i = 0; i < kLen; ++i) {
            j = (j + (mBox[i] + 256) % 256 + pass[i % pass.length]) % kLen;
            byte temp = mBox[i];
            mBox[i] = mBox[j];
            mBox[j] = temp;
        }
        return mBox;
    }

    private static int toInt(byte b) {
        return (b + 256) % 256;
    }
}

