/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.number;

import java.util.Arrays;

public final class NumberHelper {
    private NumberHelper() {
    }

    public static <T extends Comparable<T>> boolean isEquals(T a, T b) {
        return a != null && b != null && a.compareTo(b) == 0;
    }

    public static boolean greaterZero(Number number) {
        return number != null && number.doubleValue() > 0.0;
    }

    public static boolean greaterOrEqualZero(Number number) {
        return number != null && number.doubleValue() >= 0.0;
    }

    public static boolean lessZero(Number number) {
        return number != null && number.doubleValue() < 0.0;
    }

    public static boolean lessOrEqualZero(Number number) {
        return number != null && number.doubleValue() <= 0.0;
    }

    public static boolean anyGreaterZero(Number ... numbers) {
        if (numbers == null || numbers.length == 0) {
            return false;
        }
        return Arrays.stream(numbers).anyMatch(NumberHelper::greaterZero);
    }

    public static boolean allGreaterZero(Number ... numbers) {
        if (numbers == null || numbers.length == 0) {
            return false;
        }
        return Arrays.stream(numbers).allMatch(NumberHelper::greaterZero);
    }

    public static boolean anyGreaterOrEqualZero(Number ... numbers) {
        if (numbers == null || numbers.length == 0) {
            return false;
        }
        return Arrays.stream(numbers).anyMatch(NumberHelper::greaterOrEqualZero);
    }

    public static boolean allGreaterOrEqualZero(Number ... numbers) {
        if (numbers == null || numbers.length == 0) {
            return false;
        }
        return Arrays.stream(numbers).allMatch(NumberHelper::greaterOrEqualZero);
    }

    public static boolean anyLessZero(Number ... numbers) {
        if (numbers == null || numbers.length == 0) {
            return false;
        }
        return Arrays.stream(numbers).anyMatch(NumberHelper::lessZero);
    }

    public static boolean allLessZero(Number ... numbers) {
        if (numbers == null || numbers.length == 0) {
            return false;
        }
        return Arrays.stream(numbers).allMatch(NumberHelper::lessZero);
    }

    public static boolean anyLessOrEqualZero(Number ... numbers) {
        if (numbers == null || numbers.length == 0) {
            return false;
        }
        return Arrays.stream(numbers).anyMatch(NumberHelper::lessOrEqualZero);
    }

    public static boolean allLessOrEqualZero(Number ... numbers) {
        if (numbers == null || numbers.length == 0) {
            return false;
        }
        return Arrays.stream(numbers).allMatch(NumberHelper::lessOrEqualZero);
    }
}

