/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.random;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;

public final class RandomUtil {
    public static final char[] CHAR_LIST = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    private RandomUtil() {
    }

    public static String nextString(int length) {
        return RandomUtil.nextString(length, CHAR_LIST);
    }

    public static String nextString(int length, char[] chars) {
        if (length <= 0) {
            return "";
        }
        char[] nowChars = chars;
        if (nowChars == null || nowChars.length == 0) {
            nowChars = CHAR_LIST;
        }
        char[] list = new char[length];
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < list.length; ++i) {
            list[i] = nowChars[random.nextInt(nowChars.length)];
        }
        return new String(list);
    }

    public static int nextInt() {
        return ThreadLocalRandom.current().nextInt();
    }

    public static int nextInt(int n) {
        return ThreadLocalRandom.current().nextInt(n);
    }

    public static int nextInt(int origin, int bound) {
        return ThreadLocalRandom.current().nextInt(origin, bound);
    }

    public static long nextLong() {
        return ThreadLocalRandom.current().nextLong();
    }

    public static long nextLong(long n) {
        return ThreadLocalRandom.current().nextLong(n);
    }

    public static long nextLong(long origin, long bound) {
        return ThreadLocalRandom.current().nextLong(origin, bound);
    }

    public static boolean nextBoolean() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    public static float nextFloat() {
        return ThreadLocalRandom.current().nextFloat();
    }

    public static double nextDouble() {
        return ThreadLocalRandom.current().nextDouble();
    }

    public static double nextDouble(double bound) {
        return ThreadLocalRandom.current().nextDouble(bound);
    }

    public static double nextDouble(double origin, double bound) {
        return ThreadLocalRandom.current().nextDouble(origin, bound);
    }

    public static BigDecimal nextBigDecimal() {
        return BigDecimal.valueOf(RandomUtil.nextDouble());
    }

    public static BigInteger nextBigInteger() {
        return BigInteger.valueOf(RandomUtil.nextLong());
    }
}

