/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.reflection;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FieldUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldUtil.class);
    private static final Class<?>[] BASE_NUMBER_CLASS_LIST = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static SoftReference<Map<Class<?>, List<Field>>> CACHE = new SoftReference(new ConcurrentHashMap());

    private FieldUtil() {
    }

    private static Map<Class<?>, List<Field>> getCache() {
        Map<Class<?>, List<Field>> caches = CACHE.get();
        if (caches == null) {
            caches = new ConcurrentHashMap(8);
            CACHE = new SoftReference((ConcurrentHashMap<Class<?>, List<Field>>)caches);
        }
        return caches;
    }

    public static Object get(Object object, Field field) {
        try {
            return FieldUtil.read(object, field);
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Object get(Object object, String name) {
        return FieldUtil.get(object, FieldUtil.getField(object.getClass(), name));
    }

    public static Object read(Object object, String name) throws IllegalAccessException, InvocationTargetException, IntrospectionException {
        return FieldUtil.read(object, FieldUtil.getField(object.getClass(), name));
    }

    public static Object read(Object object, Field field) throws IllegalAccessException, InvocationTargetException, IntrospectionException {
        if (field == null) {
            return null;
        }
        if (Modifier.isPublic(field.getModifiers())) {
            return field.get(object);
        }
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field.getName(), object.getClass());
        Method method = propertyDescriptor.getReadMethod();
        return method.invoke(object, new Object[0]);
    }

    public static void put(Object object, Field field, Object value) {
        try {
            FieldUtil.write(object, field, value);
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
        }
    }

    public static void put(Object object, String name, Object value) {
        FieldUtil.put(object, FieldUtil.getField(object.getClass(), name), value);
    }

    public static void write(Object object, String name, Object value) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        FieldUtil.write(object, FieldUtil.getField(object.getClass(), name), value);
    }

    public static void write(Object object, Field field, Object value) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        if (field == null) {
            return;
        }
        if (Modifier.isPublic(field.getModifiers())) {
            field.set(object, value);
            return;
        }
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field.getName(), object.getClass());
        Method method = propertyDescriptor.getWriteMethod();
        method.invoke(object, value);
    }

    public static boolean isNumberClass(Class<?> fieldType) {
        if (fieldType == null) {
            return false;
        }
        if (Number.class.isAssignableFrom(fieldType)) {
            return true;
        }
        return Arrays.stream(BASE_NUMBER_CLASS_LIST).anyMatch(element -> element == fieldType);
    }

    public static List<Field> getFields(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        Map<Class<?>, List<Field>> cache = FieldUtil.getCache();
        List<Field> allFields = cache.get(clazz);
        if (allFields != null) {
            return allFields;
        }
        allFields = new ArrayList<Field>();
        LinkedList classes = new LinkedList();
        Class<?> paramsClass = clazz;
        while (true) {
            Class<?> superClass = paramsClass.getSuperclass();
            classes.add(paramsClass);
            if (Object.class.equals(superClass)) break;
            paramsClass = paramsClass.getSuperclass();
        }
        while (!classes.isEmpty()) {
            allFields.addAll(Arrays.asList(((Class)classes.pollFirst()).getDeclaredFields()));
        }
        cache.put(clazz, allFields);
        return allFields;
    }

    public static Field getField(Class<?> clazz, String name) {
        return FieldUtil.getFields(clazz).stream().filter(field -> Objects.equals(field.getName(), name)).findFirst().orElse(null);
    }

    public static List<Field> getFieldsWithFilter(Class<?> clazz, Collection<Predicate<Field>> filters) {
        List<Field> list = FieldUtil.getFields(clazz);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        Stream<Field> stream = list.stream().filter(Objects::nonNull);
        if (filters != null && !filters.isEmpty()) {
            for (Predicate<Field> filter : filters) {
                if (filter == null) continue;
                stream = stream.filter(filter);
            }
        }
        return stream.collect(Collectors.toList());
    }

    @SafeVarargs
    public static List<Field> getFieldsWithFilter(Class<?> clazz, Predicate<Field> ... filters) {
        return FieldUtil.getFieldsWithFilter(clazz, Arrays.asList(filters));
    }
}

