/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.time;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ServiceLoader;
import net.guerlab.commons.time.FormatSupplier;
import net.guerlab.commons.time.formater.IsoDate;
import net.guerlab.commons.time.formater.StandardDate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeHelper.class);
    private static final List<FormatSupplier> FORMAT_SUPPLIERS = new ArrayList<FormatSupplier>();

    private TimeHelper() {
    }

    public static void addFormat(FormatSupplier formatSupplier) {
        if (formatSupplier != null) {
            FORMAT_SUPPLIERS.add(formatSupplier);
        }
    }

    public static ZoneOffset getZoneOffset(ZoneId zoneId) {
        return zoneId.getRules().getOffset(Instant.now());
    }

    public static String format(TemporalAccessor temporal, DateTimeFormatter formatter) {
        if (temporal == null || formatter == null) {
            return null;
        }
        return formatter.format(temporal);
    }

    public static String format(TemporalAccessor temporal, String pattern) {
        if (temporal == null || StringUtils.isBlank((CharSequence)pattern)) {
            return null;
        }
        return TimeHelper.format(temporal, DateTimeFormatter.ofPattern(pattern));
    }

    public static String format(TemporalAccessor temporal) {
        return TimeHelper.format(temporal, StandardDate.INSTANCE.get());
    }

    public static String format(Date date, DateTimeFormatter formatter) {
        if (date == null) {
            return null;
        }
        return TimeHelper.format((TemporalAccessor)date.toInstant().atZone(ZoneId.systemDefault()), formatter);
    }

    public static String format(Date date, String pattern) {
        if (date == null || StringUtils.isBlank((CharSequence)pattern)) {
            return null;
        }
        return TimeHelper.format(date, DateTimeFormatter.ofPattern(pattern));
    }

    public static String format(Date date) {
        return TimeHelper.format(date, StandardDate.INSTANCE.get());
    }

    public static String formatDate(Date date) {
        return TimeHelper.format(date, IsoDate.INSTANCE.get());
    }

    public static String formatDate(TemporalAccessor temporal) {
        return TimeHelper.format(temporal, IsoDate.INSTANCE.get());
    }

    public static Date parse(String string) {
        Instant instant = TimeHelper.parseInstant(string);
        return instant == null ? null : Date.from(TimeHelper.parseInstant(string));
    }

    public static LocalDateTime parseLocalDateTime(String string) {
        Instant instant = TimeHelper.parseInstant(string);
        return instant == null ? null : LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static LocalDate parseLocalDate(String string) {
        return TimeHelper.parse(string, temporal -> temporal.isSupported(ChronoField.EPOCH_DAY) ? LocalDate.ofEpochDay(temporal.getLong(ChronoField.EPOCH_DAY)) : null);
    }

    public static LocalTime parseLocalTime(String string) {
        return TimeHelper.parse(string, temporal -> temporal.isSupported(ChronoField.NANO_OF_DAY) ? LocalTime.ofNanoOfDay(temporal.getLong(ChronoField.NANO_OF_DAY)) : null);
    }

    public static Instant parseInstant(String string) {
        return TimeHelper.parse(string, temporal -> temporal.isSupported(ChronoField.INSTANT_SECONDS) ? Instant.ofEpochSecond(temporal.getLong(ChronoField.INSTANT_SECONDS)) : null);
    }

    public static <R extends TemporalAccessor> R parse(String string, TemporalQuery<R> query) {
        String text = StringUtils.trimToNull((String)string);
        if (text == null) {
            return null;
        }
        TemporalAccessor temporal = TimeHelper.numberParse(text);
        if (temporal == null) {
            temporal = TimeHelper.textParse(text);
        }
        return (R)(temporal == null ? null : (TemporalAccessor)temporal.query(query));
    }

    private static TemporalAccessor numberParse(String text) {
        try {
            long timestamp = Long.parseLong(text);
            return Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault());
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static TemporalAccessor textParse(String text) {
        ZoneId zoneId = ZoneId.systemDefault();
        for (FormatSupplier format : FORMAT_SUPPLIERS) {
            try {
                return ((DateTimeFormatter)format.get()).withZone(zoneId).parse(text);
            }
            catch (Exception e) {
                LOGGER.trace(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    static {
        ServiceLoader.load(FormatSupplier.class).forEach(TimeHelper::addFormat);
    }
}

