/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.time.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class LocalDateTimeSerializer
extends JsonSerializer<LocalDateTime> {
    public void serialize(LocalDateTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        long time = value.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        gen.writeNumber(time);
    }
}

