/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.aliyun;

import com.fasterxml.jackson.databind.ObjectMapper;
import net.guerlab.sms.aliyun.AliyunProperties;
import net.guerlab.sms.aliyun.AliyunSendHandler;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@Conditional(value={EnableCondition.class})
@EnableConfigurationProperties(value={AliyunProperties.class})
public class AliyunAutoConfigure {
    @Bean
    @RefreshScope
    public AliyunSendHandler aliyunSendHandler(AliyunProperties properties, ObjectMapper objectMapper) {
        return new AliyunSendHandler(properties, objectMapper);
    }

    public static class EnableCondition
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return (Boolean)context.getEnvironment().getProperty("sms.aliyun.enable", Boolean.TYPE, (Object)true);
        }
    }
}

