/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.aliyun;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.sms.aliyun.AliyunProperties;
import net.guerlab.sms.core.domain.NoticeData;
import net.guerlab.sms.core.handler.SendHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunSendHandler
implements SendHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliyunSendHandler.class);
    private static final String OK = "OK";
    private static final String PRODUCT = "Dysmsapi";
    private static final String DOMAIN = "dysmsapi.aliyuncs.com";
    private AliyunProperties properties;
    private ObjectMapper objectMapper;
    private IAcsClient acsClient;

    public AliyunSendHandler(AliyunProperties properties, ObjectMapper objectMapper) {
        this.properties = properties;
        this.objectMapper = objectMapper;
        this.initClient();
    }

    private void initClient() {
        String endPoint = this.properties.getEndpoint();
        String accessKeyId = this.properties.getAccessKeyId();
        String accessKeySecret = this.properties.getAccessKeySecret();
        DefaultProfile profile = DefaultProfile.getProfile((String)endPoint, (String)accessKeyId, (String)accessKeySecret);
        try {
            DefaultProfile.addEndpoint((String)endPoint, (String)endPoint, (String)PRODUCT, (String)DOMAIN);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            throw new ApplicationException((Throwable)e);
        }
        this.acsClient = new DefaultAcsClient((IClientProfile)profile);
    }

    public void send(NoticeData noticeData, Collection<String> phones) {
        String paramString = null;
        try {
            paramString = this.objectMapper.writeValueAsString((Object)noticeData.getParams());
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return;
        }
        SendSmsRequest request = new SendSmsRequest();
        request.setMethod(MethodType.POST);
        request.setPhoneNumbers(StringUtils.join(phones, (String)","));
        request.setSignName(this.properties.getSignName());
        request.setTemplateCode(this.properties.getTemplates(noticeData.getType()));
        request.setTemplateParam(paramString);
        try {
            SendSmsResponse sendSmsResponse = (SendSmsResponse)this.acsClient.getAcsResponse((AcsRequest)request);
            if (!OK.equals(sendSmsResponse.getCode())) {
                LOGGER.debug("send fail[code={}, message={}]", (Object)sendSmsResponse.getCode(), (Object)sendSmsResponse.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }
}

