/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.web.result;

import java.util.Collection;

/**
 * 读取数据列表命令
 *
 * @author guer
 *
 * @param <T>
 *            参数类型
 */
@FunctionalInterface
public interface ReadDataListCommand<T> {

    /**
     * 获取数据列表
     *
     * @return 数据列表
     */
    Collection<T> getData();
}
