/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.web.result;

import java.util.Collection;
import java.util.Collections;
import net.guerlab.web.result.ReadDataListCommand;

public class ListObject<T> {
    public static final ListObject EMPTY = new EmptyListObject();
    private Collection<T> list = Collections.emptyList();
    private long count = 0L;
    private long pageSize = 10L;
    private long currentPageId = 1L;
    private long maxPageId = 1L;

    public ListObject() {
    }

    public ListObject(int pageSize) {
        this.pageSize = pageSize;
    }

    public ListObject(long pageSize, long count) {
        this.pageSize = pageSize;
        this.count = count;
    }

    public ListObject(long pageSize, long count, Collection<T> dataList) {
        this(pageSize, count);
        if (dataList != null) {
            this.list = dataList;
        }
    }

    public ListObject(long pageSize, long count, ReadDataListCommand<T> command) {
        this(pageSize, count);
        if (count <= 0L || command == null) {
            return;
        }
        Collection<T> dataList = command.getData();
        if (dataList != null) {
            this.list = dataList;
        }
    }

    public static <T> ListObject<T> empty() {
        return EMPTY;
    }

    public Collection<T> getList() {
        return this.list;
    }

    public void setList(Collection<T> list) {
        this.list = list;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public long getCurrentPageId() {
        return this.currentPageId;
    }

    public void setCurrentPageId(long currentPageId) {
        this.currentPageId = currentPageId;
    }

    public long getMaxPageId() {
        return this.maxPageId;
    }

    public void setMaxPageId(long maxPageId) {
        this.maxPageId = maxPageId;
    }

    private static class EmptyListObject<E>
    extends ListObject<E> {
        private EmptyListObject() {
        }

        @Override
        public void setList(Collection<E> list) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCount(long count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPageSize(long pageSize) {
            throw new UnsupportedOperationException();
        }
    }
}

