/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.web.result;

import java.util.ArrayList;
import java.util.List;
import net.guerlab.web.result.ApplicationStackTrace;

public class Result<T> {
    protected boolean status;
    protected String message;
    protected T data;
    protected int errorCode;
    protected String errorDetail;
    protected List<ApplicationStackTrace> stackTraces = new ArrayList<ApplicationStackTrace>();

    public Result() {
        this(null, null);
    }

    public Result(String message) {
        this(false, message, null);
    }

    public Result(String message, T data) {
        this(false, message, data);
    }

    public Result(String message, int errorCode) {
        this(false, message, null, errorCode);
    }

    public Result(boolean status, String message, T data) {
        this(status, message, data, 0);
    }

    public Result(boolean status, String message, T data, int errorCode) {
        this.status = status;
        this.message = message;
        this.data = data;
        this.errorCode = errorCode;
    }

    public final boolean isStatus() {
        return this.status;
    }

    public final void setStatus(boolean status) {
        this.status = status;
    }

    public final String getMessage() {
        return this.message;
    }

    public final void setMessage(String message) {
        this.message = message;
    }

    public final T getData() {
        return this.data;
    }

    public final void setData(T data) {
        this.data = data;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorDetail() {
        return this.errorDetail;
    }

    public void setErrorDetail(String errorDetail) {
        this.errorDetail = errorDetail;
    }

    public List<ApplicationStackTrace> getStackTraces() {
        return this.stackTraces;
    }

    public void setStackTraces(List<ApplicationStackTrace> stackTraces) {
        this.stackTraces = stackTraces;
    }

    public Result<T> addStackTraces(List<ApplicationStackTrace> stackTraces) {
        if (stackTraces != null && this.stackTraces != null) {
            this.stackTraces.addAll(stackTraces);
        }
        return this;
    }

    public Result<T> addStackTraces(ApplicationStackTrace stackTrace) {
        if (stackTrace != null && this.stackTraces != null) {
            this.stackTraces.add(stackTrace);
        }
        return this;
    }

    public String toString() {
        return "Result [status=" + this.status + ", message=" + this.message + ", data=" + this.data + ", errorCode=" + this.errorCode + ", errorDetail=" + this.errorDetail + "]";
    }
}

