package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 银行间连商户修改
 *
 * @author auto create
 * @since 1.0, 2017-05-25 18:14:45
 */
public class AntMerchantExpandIndirectModifyModel extends AlipayObject {

    private static final long serialVersionUID = 5427572132774822977L;

    /**
     * 商户地址信息
     */
    @ApiListField("address_info")
    @ApiField("address_info")
    private List<AddressInfo> addressInfo;

    /**
     * 商户简称
     */
    @ApiField("alias_name")
    private String aliasName;

    /**
     * 商户对应银行所开立的结算卡信息
     */
    @ApiListField("bankcard_info")
    @ApiField("bank_card_info")
    private List<BankCardInfo> bankcardInfo;

    /**
     * 商户证件编号（企业或者个体工商户提供营业执照，事业单位提供事证号）
     */
    @ApiField("business_license")
    private String businessLicense;

    /**
     * 商户证件类型，取值范围：NATIONAL_LEGAL：营业执照；NATIONAL_LEGAL_MERGE:营业执照(多证合一)；INST_RGST_CTF：事业单位法人证书
     */
    @ApiField("business_license_type")
    private String businessLicenseType;

    /**
     * 商户经营类目，参考文档：https://doc.open.alipay.com/doc2/detail?&amp;docType=1&amp;articleId=105444
     */
    @ApiField("category_id")
    private String categoryId;

    /**
     * 商户负责人信息
     */
    @ApiListField("contact_info")
    @ApiField("contact_info")
    private List<ContactInfo> contactInfo;

    /**
     * 商户编号，由机构定义，需要保证在机构下唯一，与sub_merchant_id二选一
     */
    @ApiField("external_id")
    private String externalId;

    /**
     * 受理商户的支付宝账号（用于关联商户生活号、原服务窗，打通口碑营销活动）
     */
    @ApiListField("logon_id")
    @ApiField("string")
    private List<String> logonId;

    /**
     * 商户备注信息，可填写额外信息
     */
    @ApiField("memo")
    private String memo;

    /**
     * 商户名称
     */
    @ApiField("name")
    private String name;

    /**
     * 受理商户的固定二维码链接地址（即一码多付页面地址，用于后续支付宝营销活动） 商户所属的银行或ISV 给商户的二维码url值
     * 一码多付方案:https://doc.open.alipay.com/docs/doc.htm?docType=1&amp;articleId=105672
     */
    @ApiListField("pay_code_info")
    @ApiField("string")
    private List<String> payCodeInfo;

    /**
     * 商户客服电话
     */
    @ApiField("service_phone")
    private String servicePhone;

    /**
     * 商户来源机构标识，填写机构在支付宝的pid
     */
    @ApiField("source")
    private String source;

    /**
     * 商户在支付宝入驻成功后，生成的支付宝内全局唯一的商户编号，与external_id二选一
     */
    @ApiField("sub_merchant_id")
    private String subMerchantId;

    public List<AddressInfo> getAddressInfo() {
        return this.addressInfo;
    }

    public void setAddressInfo(
            List<AddressInfo> addressInfo) {
        this.addressInfo = addressInfo;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public void setAliasName(
            String aliasName) {
        this.aliasName = aliasName;
    }

    public List<BankCardInfo> getBankcardInfo() {
        return this.bankcardInfo;
    }

    public void setBankcardInfo(
            List<BankCardInfo> bankcardInfo) {
        this.bankcardInfo = bankcardInfo;
    }

    public String getBusinessLicense() {
        return this.businessLicense;
    }

    public void setBusinessLicense(
            String businessLicense) {
        this.businessLicense = businessLicense;
    }

    public String getBusinessLicenseType() {
        return this.businessLicenseType;
    }

    public void setBusinessLicenseType(
            String businessLicenseType) {
        this.businessLicenseType = businessLicenseType;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(
            String categoryId) {
        this.categoryId = categoryId;
    }

    public List<ContactInfo> getContactInfo() {
        return this.contactInfo;
    }

    public void setContactInfo(
            List<ContactInfo> contactInfo) {
        this.contactInfo = contactInfo;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(
            String externalId) {
        this.externalId = externalId;
    }

    public List<String> getLogonId() {
        return this.logonId;
    }

    public void setLogonId(
            List<String> logonId) {
        this.logonId = logonId;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(
            String memo) {
        this.memo = memo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(
            String name) {
        this.name = name;
    }

    public List<String> getPayCodeInfo() {
        return this.payCodeInfo;
    }

    public void setPayCodeInfo(
            List<String> payCodeInfo) {
        this.payCodeInfo = payCodeInfo;
    }

    public String getServicePhone() {
        return this.servicePhone;
    }

    public void setServicePhone(
            String servicePhone) {
        this.servicePhone = servicePhone;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(
            String source) {
        this.source = source;
    }

    public String getSubMerchantId() {
        return this.subMerchantId;
    }

    public void setSubMerchantId(
            String subMerchantId) {
        this.subMerchantId = subMerchantId;
    }

}
