/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.internal.controller.inside;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.Collection;
import net.guerlab.smart.pay.core.domain.PayOrderDTO;
import net.guerlab.smart.pay.core.exception.PayOrderInvalidException;
import net.guerlab.smart.pay.core.searchparams.PayOrderSearchParams;
import net.guerlab.smart.pay.service.entity.PayOrder;
import net.guerlab.smart.pay.service.service.PayOrderService;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u652f\u4ed8\u8ba2\u5355")
@RestController(value="/inside/payOrder")
@RequestMapping(value={"/inside/payOrder"})
public class PayOrderController {
    private PayOrderService service;

    @Operation(description="\u6839\u636e\u652f\u4ed8\u8ba2\u5355ID\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355")
    @GetMapping(value={"/{id}"})
    public PayOrderDTO findOne(@Parameter(name="id", required=true) @PathVariable Long id) {
        return (PayOrderDTO)((PayOrder)this.service.selectByIdOptional((Serializable)id).orElseThrow(PayOrderInvalidException::new)).convert();
    }

    @Operation(description="\u6839\u636e\u641c\u7d22\u6761\u4ef6\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u5206\u9875\u5217\u8868")
    @PostMapping
    public ListObject<PayOrderDTO> findList(@RequestBody PayOrderSearchParams searchParams) {
        return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams));
    }

    @Operation(description="\u6839\u636e\u641c\u7d22\u6761\u4ef6\u67e5\u8be2\u5168\u90e8\u652f\u4ed8\u8ba2\u5355")
    @PostMapping(value={"/all"})
    public Collection<PayOrderDTO> findAll(@RequestBody PayOrderSearchParams searchParams) {
        return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
    }

    @Operation(description="\u6dfb\u52a0\u652f\u4ed8\u8ba2\u5355")
    @PutMapping
    public PayOrderDTO add(@RequestBody PayOrderDTO dto) {
        PayOrder order = new PayOrder();
        BeanUtils.copyProperties((Object)dto, (Object)order);
        this.service.insert((Object)order);
        return (PayOrderDTO)order.convert();
    }

    @Autowired
    public void setService(PayOrderService service) {
        this.service = service;
    }
}

