/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.internal.controller.inside;

import io.swagger.annotations.ApiParam;
import java.util.Collection;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.user.core.domain.OauthDTO;
import net.guerlab.smart.user.core.exception.OauthInvalidException;
import net.guerlab.smart.user.core.searchparams.OauthSearchParams;
import net.guerlab.smart.user.service.entity.Oauth;
import net.guerlab.smart.user.service.service.OauthService;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="/inside/oauth")
@RequestMapping(value={"/inside/oauth"})
public class OauthController {
    private OauthService service;

    @GetMapping(value={"/{type}/byUserId/{id}"})
    public OauthDTO byUserId(@ApiParam(value="type", required=true) @PathVariable String type, @ApiParam(value="id", required=true) @PathVariable Long id) {
        return (OauthDTO)((Oauth)this.service.getOneOptional(type, id).orElseThrow(OauthInvalidException::new)).toDTO();
    }

    @GetMapping(value={"/{type}/byThirdPartyId/{thirdPartyId}"})
    public OauthDTO byThirdPartyId(@ApiParam(value="type", required=true) @PathVariable String type, @ApiParam(value="thirdPartyId", required=true) @PathVariable String thirdPartyId) {
        return (OauthDTO)((Oauth)this.service.getOneOptional(type, thirdPartyId).orElseThrow(OauthInvalidException::new)).toDTO();
    }

    @PostMapping
    public ListObject<OauthDTO> findList(@RequestBody OauthSearchParams searchParams) {
        return BeanConvertUtils.toListObject((ListObject)this.service.selectPage(searchParams));
    }

    @PostMapping(value={"/all"})
    public Collection<OauthDTO> findAll(@RequestBody OauthSearchParams searchParams) {
        return BeanConvertUtils.toList((Collection)this.service.selectAll(searchParams));
    }

    @Autowired
    public void setService(OauthService service) {
        this.service = service;
    }
}

