/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.user.internal.controller.inside;

import io.swagger.annotations.ApiParam;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import net.guerlab.smart.platform.commons.exception.UserInvalidException;
import net.guerlab.smart.platform.commons.ip.IpUtils;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.user.core.domain.PositionDataDTO;
import net.guerlab.smart.user.core.domain.UserDTO;
import net.guerlab.smart.user.core.domain.UserModifyDTO;
import net.guerlab.smart.user.core.entity.LoginResponse;
import net.guerlab.smart.user.core.entity.PasswordRequest;
import net.guerlab.smart.user.core.entity.UserInternalLoginRequest;
import net.guerlab.smart.user.core.exception.LoginTypeInvalidException;
import net.guerlab.smart.user.core.exception.NeedPasswordException;
import net.guerlab.smart.user.core.searchparams.UserSearchParams;
import net.guerlab.smart.user.core.utils.PositionUtils;
import net.guerlab.smart.user.service.entity.User;
import net.guerlab.smart.user.service.handler.PositionGetHandler;
import net.guerlab.smart.user.service.service.LoginLogService;
import net.guerlab.smart.user.service.service.PermissionCheckService;
import net.guerlab.smart.user.service.service.PositionService;
import net.guerlab.smart.user.service.service.UserLoginService;
import net.guerlab.smart.user.service.service.UserService;
import net.guerlab.web.result.ListObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="/inside/user")
@RequestMapping(value={"/inside/user"})
public class UserController {
    private UserService service;
    private PositionGetHandler positionGetHandler;
    private PositionService positionService;
    private PermissionCheckService permissionCheckService;
    private LoginLogService loginLogService;
    private UserLoginService userLoginService;

    @GetMapping(value={"/{id}"})
    public UserDTO findOne(@ApiParam(value="id", required=true) @PathVariable Long id) {
        return (UserDTO)((User)this.service.selectByIdOptional(id).orElseThrow(UserInvalidException::new)).toDTO();
    }

    @GetMapping(value={"/findOneByUsername/{username}"})
    public UserDTO findOneByUsername(@ApiParam(value="username", required=true) @PathVariable String username) {
        User user = this.service.selectByUsername(username);
        if (user == null) {
            throw new UserInvalidException();
        }
        return (UserDTO)user.toDTO();
    }

    @GetMapping(value={"/findOneByPhone/{phone}"})
    public UserDTO findOneByPhone(@ApiParam(value="phone", required=true) @PathVariable String phone) {
        User user = this.service.selectByPhone(phone);
        if (user == null) {
            throw new UserInvalidException();
        }
        return (UserDTO)user.toDTO();
    }

    @PostMapping
    public ListObject<UserDTO> findList(@RequestBody UserSearchParams searchParams) {
        return BeanConvertUtils.toListObject((ListObject)this.service.selectPage(searchParams));
    }

    @PostMapping(value={"/all"})
    public Collection<UserDTO> findAll(@RequestBody UserSearchParams searchParams) {
        return BeanConvertUtils.toList((Collection)this.service.selectAll(searchParams));
    }

    @GetMapping(value={"/{id}/permissionKeys"})
    public Collection<String> permissionKeys(@ApiParam(value="id", required=true) @PathVariable Long id) {
        return this.service.getPermissionKeys(id);
    }

    @PostMapping(value={"/{id}/hasPermission"})
    public boolean hasPermission(@ApiParam(value="id", required=true) @PathVariable Long id, @RequestBody Collection<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return true;
        }
        return this.permissionCheckService.accept(id, "hasKey(" + StringUtils.join(keys, (String)",") + ")");
    }

    @GetMapping(value={"/{id}/position"})
    public Collection<PositionDataDTO> getPosition(@ApiParam(value="id", required=true) @PathVariable Long id) {
        return this.positionGetHandler.getPosition(id);
    }

    @GetMapping(value={"/{id}/positionKeys"})
    public Collection<String> getPositionKeys(@ApiParam(value="id", required=true) @PathVariable Long id) {
        return PositionUtils.getKeys((Collection)this.positionService.findByUserId(id));
    }

    @PostMapping(value={"/{id}/checkPassword"})
    public Boolean checkPassword(@ApiParam(value="id", required=true) @PathVariable Long id, @RequestBody PasswordRequest request) {
        User user = this.service.selectById(id);
        return user != null && !this.service.checkPasswordError(user, request.getPassword());
    }

    @PostMapping(value={"/add"})
    public UserDTO add(@RequestBody UserModifyDTO dto) {
        String password = StringUtils.trimToNull((String)dto.getPassword());
        if (password == null) {
            throw new NeedPasswordException();
        }
        User user = new User();
        BeanUtils.copyProperties((Object)dto, (Object)user);
        user.setAdmin(Boolean.valueOf(false));
        this.service.insertSelective((Object)user);
        return (UserDTO)user.toDTO();
    }

    @PostMapping(value={"/internalLogin"})
    public LoginResponse internalLogin(@RequestBody UserInternalLoginRequest request, HttpServletRequest httpRequest) {
        String loginType = StringUtils.trimToNull((String)request.getLoginType());
        if (loginType == null) {
            throw new LoginTypeInvalidException();
        }
        String ip = StringUtils.trimToNull((String)request.getIp());
        if (ip == null) {
            ip = IpUtils.getIp((HttpServletRequest)httpRequest);
        }
        User user = (User)this.service.selectByIdOptional(request.getUserId()).orElseThrow(UserInvalidException::new);
        LoginResponse loginResponse = this.userLoginService.login(user, null, ip);
        this.loginLogService.addSuccessLog(user.getUserId(), user.getName(), "USER_ID", loginType, ip);
        return loginResponse;
    }

    @Autowired
    public void setService(UserService service) {
        this.service = service;
    }

    @Autowired
    public void setPositionGetHandler(PositionGetHandler positionGetHandler) {
        this.positionGetHandler = positionGetHandler;
    }

    @Autowired
    public void setPositionService(PositionService positionService) {
        this.positionService = positionService;
    }

    @Autowired
    public void setPermissionCheckService(PermissionCheckService permissionCheckService) {
        this.permissionCheckService = permissionCheckService;
    }

    @Autowired
    public void setLoginLogService(LoginLogService loginLogService) {
        this.loginLogService = loginLogService;
    }

    @Autowired
    public void setUserLoginService(UserLoginService userLoginService) {
        this.userLoginService = userLoginService;
    }
}

