/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.web.controller;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Objects;
import net.guerlab.smart.platform.basic.auth.annotation.IgnoreLogin;
import net.guerlab.smart.platform.commons.exception.RefreshTokenInvalidException;
import net.guerlab.smart.wx.auth.WxUserContextHandler;
import net.guerlab.smart.wx.auth.utils.WxUserJwtHelper;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.smart.wx.core.domain.WxUserDTO;
import net.guerlab.smart.wx.core.entity.IJwtInfo;
import net.guerlab.smart.wx.core.exception.WxUserInvalidException;
import net.guerlab.smart.wx.service.entity.WxUser;
import net.guerlab.smart.wx.service.service.LoginService;
import net.guerlab.smart.wx.service.service.WxUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;

public abstract class AbstractWxControlPanelController<LS extends LoginService> {
    protected static final String PREFIX = "WX_USER_JWT RT ";
    protected WxUserJwtHelper jwtHelper;
    protected WxUserService wxUserService;
    protected LS loginService;

    @IgnoreLogin
    @ApiOperation(value="\u767b\u5f55")
    @GetMapping(value={"/{appId}/login/{code}"})
    public LoginResponse login(@ApiParam(value="\u5e94\u7528ID", required=true) @PathVariable String appId, @ApiParam(value="code", required=true) @PathVariable String code) {
        return this.loginService.login(appId, code);
    }

    @IgnoreLogin
    @ApiOperation(value="\u5237\u65b0Token")
    @GetMapping(value={"/{appId}/refreshToken"})
    public LoginResponse refreshToken(@ApiParam(value="\u5e94\u7528ID", required=true) @PathVariable String appId, @ApiParam(value="refreshToken", required=true) @RequestHeader(value="refreshToken") String refreshToken) {
        if (!refreshToken.startsWith(PREFIX)) {
            throw new RefreshTokenInvalidException();
        }
        String jwtToken = refreshToken.substring(PREFIX.length());
        IJwtInfo info = (IJwtInfo)this.jwtHelper.parseByRefreshTokenKey(jwtToken);
        if (!Objects.equals(appId, info.getAppId())) {
            throw new RefreshTokenInvalidException();
        }
        return this.loginService.buildLoginResponse(this.wxUserService.findUser(info.getAppId(), info.getOpenId()));
    }

    @ApiOperation(value="\u83b7\u53d6\u4e2a\u4eba\u4fe1\u606f")
    @GetMapping
    public WxUserDTO getInfo() {
        return this.findCurrentWxUser().toDTO();
    }

    protected WxUser findCurrentWxUser() {
        WxUser wxUser = this.wxUserService.findUser(WxUserContextHandler.getAppId(), WxUserContextHandler.getOpenId());
        if (wxUser == null) {
            throw new WxUserInvalidException();
        }
        return wxUser;
    }

    @Autowired
    public void setJwtHelper(WxUserJwtHelper jwtHelper) {
        this.jwtHelper = jwtHelper;
    }

    @Autowired
    public void setWxUserService(WxUserService wxUserService) {
        this.wxUserService = wxUserService;
    }

    @Autowired
    public void setLoginService(LS loginService) {
        this.loginService = loginService;
    }
}

