/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.web.controller.user.wx.ma;

import cn.binarywang.wx.miniapp.api.WxMaMsgService;
import cn.binarywang.wx.miniapp.bean.WxMaSubscribeMessage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.wx.service.service.WxMaManagerService;
import net.guerlab.smart.wx.web.controller.user.wx.ma.SubscribeMsgController;
import net.guerlab.smart.wx.web.domain.WxMaSubscribeMessageSendData;
import net.guerlab.smart.wx.web.domain.WxMaSubscribeTemplateListResult;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5fae\u4fe1-\u5c0f\u7a0b\u5e8f-\u8ba2\u9605\u6d88\u606f"})
@RestController(value="/user/wx/ma/subscribeMsg")
@RequestMapping(value={"/user/wx/ma/subscribeMsg"})
public class SubscribeMsgController {
    private static final String GET_TEMPLATE_URL = "https://api.weixin.qq.com/wxaapi/newtmpl/gettemplate";
    private WxMaManagerService maManagerService;

    @ApiOperation(value="\u83b7\u53d6\u5217\u8868")
    @GetMapping(value={"/{appId}/templateList"})
    public List<WxMaSubscribeTemplateListResult.TemplateItem> list(@ApiParam(value="\u5e94\u7528ID", required=true) @PathVariable String appId) {
        try {
            String responseText = this.maManagerService.getService(appId).get(GET_TEMPLATE_URL, "");
            WxMaSubscribeTemplateListResult result = WxMaSubscribeTemplateListResult.fromJson((String)responseText);
            return result.getData();
        }
        catch (WxErrorException e) {
            throw new ApplicationException(e.getError().getErrorMsg(), e.getError().getErrorCode());
        }
    }

    @ApiOperation(value="\u53d1\u9001\u8ba2\u9605\u901a\u77e5")
    @PostMapping(value={"/{appId}/sendMsg"})
    public Map<String, SendMsgResponse> sendMsg(@ApiParam(value="\u5e94\u7528ID", required=true) @PathVariable String appId, @RequestBody WxMaSubscribeMessageSendData sendData) {
        Collection<Object> openIds = sendData.getOpenIds();
        if (openIds == null) {
            openIds = Collections.emptyList();
        }
        if (CollectionUtil.isEmpty(openIds = (Collection)openIds.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList()))) {
            return Collections.emptyMap();
        }
        WxMaSubscribeMessage msg = sendData.getMsg();
        WxMaMsgService wxMaMsgService = this.maManagerService.getService(appId).getMsgService();
        ConcurrentHashMap<String, SendMsgResponse> result = new ConcurrentHashMap<String, SendMsgResponse>(openIds.size());
        openIds.forEach(openId -> {
            WxMaSubscribeMessage sendMsg = new WxMaSubscribeMessage();
            sendMsg.setData(msg.getData());
            sendMsg.setPage(msg.getPage());
            sendMsg.setTemplateId(msg.getTemplateId());
            sendMsg.setToUser(openId);
            SendMsgResponse response = new SendMsgResponse();
            result.put((String)openId, response);
            try {
                wxMaMsgService.sendSubscribeMsg(sendMsg);
                response.status = true;
            }
            catch (WxErrorException e) {
                WxError error = e.getError();
                response.errorCode = error.getErrorCode();
                response.errorMsg = error.getErrorMsg();
            }
            catch (Exception e) {
                response.errorMsg = e.getLocalizedMessage();
            }
        });
        return result;
    }

    @Autowired
    public void setMpManagerService(WxMaManagerService maManagerService) {
        this.maManagerService = maManagerService;
    }
}

