/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.web.controller.user.wx.mp;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import me.chanjar.weixin.mp.api.WxMpUserService;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import me.chanjar.weixin.mp.bean.result.WxMpUserList;
import net.guerlab.smart.wx.core.exception.WxAppInvalidException;
import net.guerlab.smart.wx.core.exception.WxMpUserSynchronizingException;
import net.guerlab.smart.wx.service.entity.WxApp;
import net.guerlab.smart.wx.service.entity.WxUser;
import net.guerlab.smart.wx.service.service.WxAppService;
import net.guerlab.smart.wx.service.service.WxMpManagerService;
import net.guerlab.smart.wx.service.service.WxUserService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5fae\u4fe1-\u516c\u4f17\u53f7-\u7528\u6237\u7ba1\u7406"})
@RestController(value="/user/wx/mp/user")
@RequestMapping(value={"/user/wx/mp/user"})
public class UserController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() * 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
        Thread thread = new Thread(r);
        thread.setName("async_wx_mp_user");
        return thread;
    });
    private final Map<String, AtomicBoolean> lockMap = new ConcurrentHashMap(8);
    private WxMpManagerService mpManagerService;
    private WxUserService wxUserService;
    private WxAppService wxAppService;

    @ApiOperation(value="\u540c\u6b65\u7528\u6237\u4fe1\u606f")
    @PostMapping(value={"/{appId}/userSync"})
    public void userSync(@ApiParam(value="\u5e94\u7528ID", required=true) @PathVariable String appId) {
        AtomicBoolean flag = this.lockMap.computeIfAbsent(appId, s -> new AtomicBoolean());
        if (!flag.compareAndSet(false, true)) {
            throw new WxMpUserSynchronizingException();
        }
        WxApp wxApp = (WxApp)this.wxAppService.selectByIdOptional((Object)appId).orElseThrow(WxAppInvalidException::new);
        this.executor.execute(() -> {
            try {
                this.userSyncThread(appId, wxApp.getAppName());
            }
            catch (Exception e) {
                log.debug(e.getLocalizedMessage(), (Throwable)e);
            }
            finally {
                flag.set(false);
            }
        });
    }

    private void userSyncThread(String appId, String appName) throws Exception {
        WxMpUserService userService = this.mpManagerService.getService(appId).getUserService();
        boolean hasMore = true;
        String nextOpenid = null;
        log.debug("user sync start[appId: {}]", (Object)appId);
        while (hasMore) {
            WxMpUserList wxMpUserList = userService.userList(nextOpenid);
            nextOpenid = wxMpUserList.getNextOpenid();
            hasMore = StringUtils.isNotBlank((CharSequence)nextOpenid);
            List openIds = wxMpUserList.getOpenids();
            if (openIds.isEmpty()) break;
            userService.userInfoList(wxMpUserList.getOpenids()).forEach(user -> this.userSyncHandler(appId, appName, user));
        }
        log.debug("user sync finished[appId: {}]", (Object)appId);
    }

    private void userSyncHandler(String appId, String appName, WxMpUser user) {
        WxUser wxUser = this.wxUserService.findUser(appId, user.getOpenId());
        if (wxUser == null) {
            wxUser = new WxUser();
            wxUser.setOpenId(user.getOpenId());
            wxUser.setAppId(appId);
            wxUser.setUnionId(user.getUnionId());
            wxUser.setAppName(appName);
            wxUser.setUnionId(user.getUnionId());
            wxUser.setAvatarUrl(user.getHeadImgUrl());
            wxUser.setNickName(user.getNickname());
            this.wxUserService.insertSelective((Object)wxUser);
        } else {
            WxUser update = new WxUser();
            update.setOpenId(wxUser.getOpenId());
            update.setAppId(appId);
            update.setUnionId(user.getUnionId());
            update.setAvatarUrl(user.getHeadImgUrl());
            update.setNickName(user.getNickname());
            update.setVersion(wxUser.getVersion());
            this.wxUserService.updateSelectiveById((Object)update);
        }
    }

    @Autowired
    public void setMpManagerService(WxMpManagerService mpManagerService) {
        this.mpManagerService = mpManagerService;
    }

    @Autowired
    public void setWxUserService(WxUserService wxUserService) {
        this.wxUserService = wxUserService;
    }

    @Autowired
    public void setWxAppService(WxAppService wxAppService) {
        this.wxAppService = wxAppService;
    }
}

