/*
 * Decompiled with CFR 0.152.
 */
package net.guoyk.azuki;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.guoyk.azuki.AzukiException;
import net.guoyk.azuki.Expression;
import net.guoyk.azuki.expressions.AllExpression;
import net.guoyk.azuki.expressions.AnyExpression;
import net.guoyk.azuki.expressions.ContainsExpression;
import net.guoyk.azuki.expressions.ContainsIgnoreCaseExpression;
import net.guoyk.azuki.expressions.EndsWithExpression;
import net.guoyk.azuki.expressions.EndsWithIgnoreCaseExpression;
import net.guoyk.azuki.expressions.EqualsExpression;
import net.guoyk.azuki.expressions.EqualsIgnoreCaseExpression;
import net.guoyk.azuki.expressions.ExistsExpression;
import net.guoyk.azuki.expressions.NoneExpression;
import net.guoyk.azuki.expressions.NotExpression;
import net.guoyk.azuki.expressions.RegExpExpression;
import net.guoyk.azuki.expressions.StartsWithExpression;
import net.guoyk.azuki.expressions.StartsWithIgnoreCaseExpression;

public class Azuki {
    private static final HashMap<String, Class<? extends Expression>> EXPRESSIONS = new HashMap();

    public static void register(String name, Class<? extends Expression> expressionClass) {
        EXPRESSIONS.put(name, expressionClass);
    }

    public static Expression build(Object object) throws AzukiException {
        if (object == null) {
            throw new AzukiException(new IllegalArgumentException());
        }
        if (!(object instanceof Map)) {
            throw new AzukiException("build must be invoked on a Map object");
        }
        Map map = (Map)object;
        if (map.size() != 1) {
            throw new AzukiException("Map must have and only have one expression");
        }
        Map.Entry entry = map.entrySet().iterator().next();
        if (!(entry.getKey() instanceof String)) {
            throw new AzukiException("key must be string");
        }
        Class<? extends Expression> aClass = EXPRESSIONS.get(entry.getKey());
        if (aClass == null) {
            throw new AzukiException("Expression not supported: " + entry.getKey());
        }
        try {
            return aClass.getConstructor(Object.class).newInstance(entry.getValue());
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof AzukiException) {
                throw (AzukiException)e.getCause();
            }
            throw new AzukiException(e);
        }
        catch (Throwable e) {
            throw new AzukiException(e);
        }
    }

    static {
        Azuki.register("all", AllExpression.class);
        Azuki.register("and", AllExpression.class);
        Azuki.register("any", AnyExpression.class);
        Azuki.register("or", AnyExpression.class);
        Azuki.register("none", NoneExpression.class);
        Azuki.register("not", NotExpression.class);
        Azuki.register("equals", EqualsExpression.class);
        Azuki.register("equalsIgnoreCase", EqualsIgnoreCaseExpression.class);
        Azuki.register("startsWith", StartsWithExpression.class);
        Azuki.register("startsWithIgnoreCase", StartsWithIgnoreCaseExpression.class);
        Azuki.register("endsWith", EndsWithExpression.class);
        Azuki.register("endsWithIgnoreCase", EndsWithIgnoreCaseExpression.class);
        Azuki.register("contains", ContainsExpression.class);
        Azuki.register("containsIgnoreCase", ContainsIgnoreCaseExpression.class);
        Azuki.register("pattern", RegExpExpression.class);
        Azuki.register("regexp", RegExpExpression.class);
        Azuki.register("exists", ExistsExpression.class);
    }
}

