/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javaslang.collection.List;
import javaslang.collection.Seq;
import javaslang.control.Option;

public abstract class Json {
    private Json() {
    }

    public static JString jString(String value) {
        return new JString(value);
    }

    public static JBoolean jBoolean(boolean value) {
        return new JBoolean(value);
    }

    public static JNumber jNumber(BigDecimal value) {
        return new JNumber(value);
    }

    public static JNumber jNumber(int n) {
        return new JNumber(new BigDecimal(n));
    }

    public static JNumber jNumber(double n) {
        return new JNumber(new BigDecimal(n));
    }

    public static JNumber jNumber(long n) {
        return new JNumber(new BigDecimal(n));
    }

    public static JNumber jNumber(Number n) {
        if (n instanceof BigDecimal) {
            return new JNumber((BigDecimal)n);
        }
        return new JNumber(new BigDecimal(n.toString()));
    }

    public static JNull jNull() {
        return JNull.INSTANCE;
    }

    public static JArray jEmptyArray() {
        return new JArray((Seq)List.nil());
    }

    public static JArray jArray(Iterable<JValue> iterable) {
        return new JArray((Seq)List.ofAll(iterable));
    }

    public static JArray jArray(JValue first, JValue ... rest) {
        return new JArray((Seq)List.of((Object[])rest).prepend((Object)first));
    }

    public static JObject jEmptyObject() {
        return new JObject(Collections.emptyMap());
    }

    public static JObject jObject(String name, JValue value) {
        return new JObject(Collections.singletonMap(name, value));
    }

    @SafeVarargs
    public static JObject jObject(Map.Entry<String, JValue> first, Map.Entry<String, JValue> ... list) {
        LinkedHashMap<String, JValue> map = new LinkedHashMap<String, JValue>(list.length + 1);
        map.put(first.getKey(), first.getValue());
        for (Map.Entry<String, JValue> entry : list) {
            map.put(entry.getKey(), entry.getValue());
        }
        return new JObject(map);
    }

    public static JObject jObject(Iterable<Map.Entry<String, JValue>> value) {
        LinkedHashMap<String, JValue> map = new LinkedHashMap<String, JValue>();
        for (Map.Entry<String, JValue> e : value) {
            map.put(e.getKey(), e.getValue());
        }
        return new JObject(map);
    }

    public static JObject jObject(Map<String, JValue> value) {
        LinkedHashMap<String, JValue> map = new LinkedHashMap<String, JValue>(value);
        return new JObject(map);
    }

    private static <A, B> Function<A, Option<B>> emptyOption() {
        return ignore -> Option.none();
    }

    public static final class JObject
    extends JValue
    implements Iterable<Map.Entry<String, JValue>> {
        public Map<String, JValue> value;

        private JObject(Map<String, JValue> value) {
            this.value = Collections.unmodifiableMap(value);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JObject jObject = (JObject)o;
            return this.value.equals(jObject.value);
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return "JObject{value=" + this.value + '}';
        }

        @Override
        public <X> X fold(Function<JString, X> fString, Function<JBoolean, X> fBoolean, Function<JNumber, X> fNumber, Function<JObject, X> fObject, Function<JArray, X> fArray, Supplier<X> fNull) {
            return fObject.apply(this);
        }

        @Override
        public void foldUnit(Consumer<JString> fString, Consumer<JBoolean> fBoolean, Consumer<JNumber> fNumber, Consumer<JObject> fObject, Consumer<JArray> fArray, Runnable fNull) {
            fObject.accept(this);
        }

        public Map<String, JValue> getValue() {
            return this.value;
        }

        public Option<JValue> get(String name) {
            return Option.of((Object)this.value.get(name));
        }

        public <A> Option<A> getAs(String name, Function<JValue, Option<A>> f) {
            return this.get(name).flatMap(f);
        }

        public Option<String> getAsString(String name) {
            return this.getAs(name, JValue::asString);
        }

        public Option<BigDecimal> getAsBigDecimal(String name) {
            return this.getAs(name, JValue::asBigDecimal);
        }

        public Option<Boolean> getAsBoolean(String name) {
            return this.getAs(name, JValue::asBoolean);
        }

        public boolean isEmpty() {
            return this.value.isEmpty();
        }

        public boolean containsKey(String key) {
            return this.value.containsKey(key);
        }

        public boolean containsValue(JValue value) {
            return this.value.containsValue(value);
        }

        public Collection<JValue> values() {
            return this.value.values();
        }

        public Set<Map.Entry<String, JValue>> entrySet() {
            return this.value.entrySet();
        }

        public void forEach(BiConsumer<String, JValue> action) {
            this.value.forEach(action);
        }

        public <B> Seq<B> mapToList(BiFunction<String, JValue, B> f) {
            return (Seq)this.entrySet().stream().map(e -> f.apply((String)e.getKey(), (JValue)e.getValue())).collect(List.collector());
        }

        public <B> Seq<B> mapValues(Function<JValue, B> f) {
            return (Seq)this.values().stream().map(f).collect(List.collector());
        }

        public JValue getOrDefault(String key, JValue defaultValue) {
            return this.value.getOrDefault(key, defaultValue);
        }

        public int size() {
            return this.value.size();
        }

        public Set<String> keySet() {
            return this.value.keySet();
        }

        @Override
        public Iterator<Map.Entry<String, JValue>> iterator() {
            return this.entrySet().iterator();
        }

        public Stream<Map.Entry<String, JValue>> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        public JObject put(String name, JValue value) {
            Map<String, JValue> map = this.copyMap();
            map.put(name, value);
            return new JObject(map);
        }

        private Map<String, JValue> copyMap() {
            return new LinkedHashMap<String, JValue>(this.value);
        }
    }

    public static final class JArray
    extends JValue
    implements Iterable<JValue> {
        public Seq<JValue> value;

        private JArray(Seq<JValue> value) {
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JArray jArray = (JArray)o;
            return this.value.equals(jArray.value);
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return "JArray{value=" + this.value + '}';
        }

        @Override
        public <X> X fold(Function<JString, X> fString, Function<JBoolean, X> fBoolean, Function<JNumber, X> fNumber, Function<JObject, X> fObject, Function<JArray, X> fArray, Supplier<X> fNull) {
            return fArray.apply(this);
        }

        @Override
        public void foldUnit(Consumer<JString> fString, Consumer<JBoolean> fBoolean, Consumer<JNumber> fNumber, Consumer<JObject> fObject, Consumer<JArray> fArray, Runnable fNull) {
            fArray.accept(this);
        }

        public Seq<JValue> getValue() {
            return this.value;
        }

        @Override
        public Iterator<JValue> iterator() {
            return this.value.iterator();
        }

        public Stream<JValue> stream() {
            return StreamSupport.stream(this.value.spliterator(), false);
        }

        public Option<JValue> get(int index) {
            return index < this.value.length() ? Option.of((Object)this.value.get(index)) : Option.none();
        }

        public Option<JValue> headOption() {
            return this.value.headOption();
        }

        public Seq<JObject> getListAsObjects() {
            return this.getListAs(JValue::asJsonObject);
        }

        public Seq<String> getListAsStrings() {
            return this.getListAs(JValue::asString);
        }

        public Seq<BigDecimal> getListAsBigDecimals() {
            return this.getListAs(JValue::asBigDecimal);
        }

        public <A> Seq<A> getListAs(Function<JValue, Option<A>> f) {
            return this.value.flatMap(j -> {
                Option opt = (Option)f.apply((JValue)j);
                return List.ofAll((Iterable)opt);
            });
        }

        public int size() {
            return this.value.length();
        }

        public JArray append(JValue toAdd) {
            return new JArray((Seq<JValue>)this.value.append((Object)toAdd));
        }

        public JArray prepend(JValue toAdd) {
            return new JArray((Seq<JValue>)this.value.prepend((Object)toAdd));
        }

        public JArray insert(int index, JValue toAdd) {
            return new JArray((Seq<JValue>)this.value.insert(index, (Object)toAdd));
        }

        public JArray remove(int index) {
            return (JArray)this.get(index).map(v -> Json.jArray((Iterable<JValue>)this.value.remove(v))).orElse((Object)this);
        }
    }

    public static final class JNumber
    extends JValue {
        public BigDecimal value;

        private JNumber(BigDecimal value) {
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JNumber jNumber = (JNumber)o;
            return this.value.equals(jNumber.value);
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return "JNumber{value=" + this.value + '}';
        }

        @Override
        public <X> X fold(Function<JString, X> fString, Function<JBoolean, X> fBoolean, Function<JNumber, X> fNumber, Function<JObject, X> fObject, Function<JArray, X> fArray, Supplier<X> fNull) {
            return fNumber.apply(this);
        }

        @Override
        public void foldUnit(Consumer<JString> fString, Consumer<JBoolean> fBoolean, Consumer<JNumber> fNumber, Consumer<JObject> fObject, Consumer<JArray> fArray, Runnable fNull) {
            fNumber.accept(this);
        }

        public long asLong() {
            return this.value.longValue();
        }

        public int asInt() {
            return this.value.intValue();
        }

        public double asDouble() {
            return this.value.doubleValue();
        }

        public BigDecimal getValue() {
            return this.value;
        }
    }

    public static final class JNull
    extends JValue {
        public static final JNull INSTANCE = new JNull();

        private JNull() {
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public int hashCode() {
            return 31;
        }

        @Override
        public String toString() {
            return "JNull";
        }

        @Override
        public <X> X fold(Function<JString, X> fString, Function<JBoolean, X> fBoolean, Function<JNumber, X> fNumber, Function<JObject, X> fObject, Function<JArray, X> fArray, Supplier<X> fNull) {
            return fNull.get();
        }

        @Override
        public void foldUnit(Consumer<JString> fString, Consumer<JBoolean> fBoolean, Consumer<JNumber> fNumber, Consumer<JObject> fObject, Consumer<JArray> fArray, Runnable fNull) {
            fNull.run();
        }
    }

    public static final class JBoolean
    extends JValue {
        public final boolean value;

        private JBoolean(boolean value) {
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JBoolean jBoolean = (JBoolean)o;
            return this.value == jBoolean.value;
        }

        @Override
        public int hashCode() {
            return this.value ? 1 : 0;
        }

        @Override
        public String toString() {
            return "JBoolean{value=" + this.value + '}';
        }

        @Override
        public <X> X fold(Function<JString, X> fString, Function<JBoolean, X> fBoolean, Function<JNumber, X> fNumber, Function<JObject, X> fObject, Function<JArray, X> fArray, Supplier<X> fNull) {
            return fBoolean.apply(this);
        }

        @Override
        public void foldUnit(Consumer<JString> fString, Consumer<JBoolean> fBoolean, Consumer<JNumber> fNumber, Consumer<JObject> fObject, Consumer<JArray> fArray, Runnable fNull) {
            fBoolean.accept(this);
        }

        public boolean isValue() {
            return this.value;
        }
    }

    public static final class JString
    extends JValue {
        public final String value;

        private JString(String value) {
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JString jString = (JString)o;
            return this.value.equals(jString.value);
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return "JString{value='" + this.value + '\'' + '}';
        }

        @Override
        public <X> X fold(Function<JString, X> fString, Function<JBoolean, X> fBoolean, Function<JNumber, X> fNumber, Function<JObject, X> fObject, Function<JArray, X> fArray, Supplier<X> fNull) {
            return fString.apply(this);
        }

        @Override
        public void foldUnit(Consumer<JString> fString, Consumer<JBoolean> fBoolean, Consumer<JNumber> fNumber, Consumer<JObject> fObject, Consumer<JArray> fArray, Runnable fNull) {
            fString.accept(this);
        }

        public String getValue() {
            return this.value;
        }
    }

    public static abstract class JValue {
        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        public abstract String toString();

        public abstract <X> X fold(Function<JString, X> var1, Function<JBoolean, X> var2, Function<JNumber, X> var3, Function<JObject, X> var4, Function<JArray, X> var5, Supplier<X> var6);

        public abstract void foldUnit(Consumer<JString> var1, Consumer<JBoolean> var2, Consumer<JNumber> var3, Consumer<JObject> var4, Consumer<JArray> var5, Runnable var6);

        public final Option<JArray> asJsonArray() {
            return this.fold(Json.emptyOption(), Json.emptyOption(), Json.emptyOption(), Json.emptyOption(), Option::of, Option::none);
        }

        public final JArray asJsonArrayOrEmpty() {
            return (JArray)this.asJsonArray().orElse((Object)Json.jEmptyArray());
        }

        public final Option<JObject> asJsonObject() {
            return this.fold(Json.emptyOption(), Json.emptyOption(), Json.emptyOption(), Option::of, Json.emptyOption(), Option::none);
        }

        public final JObject asJsonObjectOrEmpty() {
            return (JObject)this.asJsonObject().orElse((Object)Json.jEmptyObject());
        }

        public final Option<JBoolean> asJsonBoolean() {
            return this.fold(Json.emptyOption(), Option::of, Json.emptyOption(), Json.emptyOption(), Json.emptyOption(), Option::none);
        }

        public final Option<Boolean> asBoolean() {
            return this.asJsonBoolean().map(j -> j.value);
        }

        public final Option<JNull> asJsonNull() {
            return this.fold(Json.emptyOption(), Json.emptyOption(), Json.emptyOption(), Json.emptyOption(), Json.emptyOption(), () -> Option.of((Object)Json.jNull()));
        }

        public final Option<JString> asJsonString() {
            return this.fold(Option::of, Json.emptyOption(), Json.emptyOption(), Json.emptyOption(), Json.emptyOption(), Option::none);
        }

        public final Option<String> asString() {
            return this.asJsonString().map(j -> j.value);
        }

        public final Option<JNumber> asJsonNumber() {
            return this.fold(Json.emptyOption(), Json.emptyOption(), Option::of, Json.emptyOption(), Json.emptyOption(), Option::none);
        }

        public final Option<BigDecimal> asBigDecimal() {
            return this.asJsonNumber().map(j -> j.value);
        }
    }
}

