/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.io;

import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.json.stream.JsonParser;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.io.JsonParser;

public class JavaxJsonParser
extends JsonParser {
    protected Json.JValue parseImpl(Reader reader) throws Exception {
        JsonParser.Event event;
        javax.json.stream.JsonParser parser = javax.json.Json.createParser((Reader)reader);
        while ((event = parser.next()) != null) {
            if (event == JsonParser.Event.START_OBJECT) {
                return this.handleObject(parser);
            }
            if (event == JsonParser.Event.START_ARRAY) {
                return this.handleArray(parser);
            }
            if (!this.isScalar(event)) continue;
            return this.handleScalarValue(event, parser);
        }
        throw new IllegalStateException("Nothing parsed...");
    }

    private Json.JValue handleScalarValue(JsonParser.Event event, javax.json.stream.JsonParser parser) {
        switch (event) {
            case VALUE_STRING: {
                return Json.jString((String)parser.getString());
            }
            case VALUE_NUMBER: {
                return Json.jNumber((BigDecimal)parser.getBigDecimal());
            }
            case VALUE_TRUE: {
                return Json.jBoolean((boolean)true);
            }
            case VALUE_FALSE: {
                return Json.jBoolean((boolean)false);
            }
            case VALUE_NULL: {
                return Json.jNull();
            }
        }
        throw new IllegalArgumentException("Not a scalar value " + event);
    }

    private boolean isScalar(JsonParser.Event event) {
        switch (event) {
            case VALUE_STRING: 
            case VALUE_NUMBER: 
            case VALUE_TRUE: 
            case VALUE_FALSE: 
            case VALUE_NULL: {
                return true;
            }
        }
        return false;
    }

    private Json.JArray handleArray(javax.json.stream.JsonParser parser) {
        JsonParser.Event event;
        ArrayList<Object> list = new ArrayList<Object>();
        while ((event = parser.next()) != JsonParser.Event.END_ARRAY) {
            if (this.isScalar(event)) {
                list.add(this.handleScalarValue(event, parser));
                continue;
            }
            if (event == JsonParser.Event.START_OBJECT) {
                list.add(this.handleObject(parser));
                continue;
            }
            if (event != JsonParser.Event.START_ARRAY) continue;
            list.add(this.handleArray(parser));
        }
        return Json.jArray(list);
    }

    private Json.JObject handleObject(javax.json.stream.JsonParser parser) {
        JsonParser.Event event;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        String name = null;
        while ((event = parser.next()) != JsonParser.Event.END_OBJECT) {
            if (event == JsonParser.Event.KEY_NAME) {
                name = parser.getString();
            }
            if (name == null) continue;
            if (this.isScalar(event)) {
                map.put(name, this.handleScalarValue(event, parser));
                continue;
            }
            if (event == JsonParser.Event.START_OBJECT) {
                map.put(name, this.handleObject(parser));
                continue;
            }
            if (event != JsonParser.Event.START_ARRAY) continue;
            map.put(name, this.handleArray(parser));
        }
        return Json.jObject(map);
    }
}

