/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import net.cnri.util.StringEncodingException;

public abstract class StreamObjectUtil {
    public static int getNonWhitespace(Reader in) throws IOException {
        int ch;
        while ((ch = in.read()) == 32 || ch == 10 || ch == 13 || ch == 44 || ch == 59 || ch == 9) {
        }
        return ch;
    }

    public static String readUndelimitedString(Reader in, int firstChar) throws IOException {
        if (firstChar == -1) {
            return "";
        }
        StringBuffer sb = new StringBuffer("" + (char)firstChar);
        int ch;
        while ((ch = in.read()) != 32 && ch != 10 && ch != 13 && ch != 44 && ch != 59 && ch != -1 && ch != 61 && ch != 9) {
            sb.append((char)ch);
        }
        return sb.toString();
    }

    public static String readString(Reader in) throws StringEncodingException, IOException {
        StringBuffer results = new StringBuffer("");
        while (true) {
            int ch;
            if ((ch = in.read()) == -1) {
                throw new StringEncodingException("Unexpected End of String");
            }
            if (ch == 92) {
                ch = in.read();
                if (ch == -1) {
                    throw new StringEncodingException("Unexpected End of String");
                }
                if (ch == 110) {
                    results.append('\n');
                    continue;
                }
                results.append((char)ch);
                continue;
            }
            if (ch == 34) {
                return results.toString();
            }
            results.append((char)ch);
        }
    }

    public static void writeEncodedString(Writer out, String str) throws IOException {
        int n = str.length();
        out.write(34);
        for (int i = 0; i < n; ++i) {
            char ch = str.charAt(i);
            if (ch == '\"' || ch == '\\') {
                out.write(92);
            }
            out.write(ch);
        }
        out.write("\"");
    }
}

