/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import net.cnri.util.StringUtils;
import net.cnri.util.TemplateException;

public class Template {
    public static int getMatchingBraceLocation(String str) {
        int count = 0;
        int leftIdx = -1;
        int rightIdx = -1;
        int totIdx = 0;
        String str2 = str;
        while (true) {
            leftIdx = str2.indexOf("{{");
            rightIdx = str2.indexOf("}}");
            if (rightIdx < 0) {
                return -1;
            }
            if (leftIdx >= 0 && leftIdx < rightIdx) {
                ++count;
                str2 = str2.substring(leftIdx + 2, str2.length());
                totIdx += leftIdx + 2;
                continue;
            }
            str2 = str2.substring(rightIdx + 2, str2.length());
            totIdx += rightIdx + 2;
            if (count == 0) {
                return totIdx - 2;
            }
            --count;
        }
    }

    private static int getMatchingBraceLocation(StringBuilder s, int index) {
        int count = 0;
        int curr = index;
        while (true) {
            int leftIdx = s.indexOf("{{", curr);
            int rightIdx = s.indexOf("}}", curr);
            if (rightIdx < 0) {
                return -1;
            }
            if (leftIdx < 0 || leftIdx > rightIdx) {
                if (count == 0) {
                    return rightIdx;
                }
                --count;
                curr = rightIdx + 2;
                continue;
            }
            ++count;
            curr = leftIdx + 2;
        }
    }

    public static String subDictIntoFile(String filename, Map<?, ?> dict) throws IOException, TemplateException {
        return Template.subDictIntoFile(new File(filename), dict);
    }

    public static String subDictIntoFile(File file, Map<?, ?> dict) throws IOException, TemplateException {
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        StringBuilder sb = new StringBuilder();
        char[] ch = new char[256];
        int n = 0;
        while ((n = in.read(ch, 0, ch.length)) >= 0) {
            sb.append(ch, 0, n);
        }
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Template.subDictIntoString(sb.toString(), dict);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String subDictIntoStream(InputStream in, Map<?, ?> dict) throws IOException, TemplateException {
        try {
            int r;
            InputStreamReader rdr = new InputStreamReader(in, "UTF8");
            StringWriter sw = new StringWriter();
            char[] ch = new char[1024];
            while ((r = rdr.read(ch, 0, ch.length)) >= 0) {
                sw.write(ch, 0, r);
            }
            String string = Template.subDictIntoString(sw.toString(), dict);
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static String subDictIntoString(String str, Map<?, ?> dict) throws TemplateException {
        int begTag;
        StringBuilder sb = new StringBuilder(str);
        int index = 0;
        while ((begTag = sb.indexOf("{{", index)) >= 0) {
            String extra;
            int endTag = Template.getMatchingBraceLocation(sb, begTag + 2);
            if (endTag < 0) {
                throw new TemplateException("Unmatched {{.");
            }
            int doubleColonIdx = sb.indexOf("::", begTag + 2);
            if (doubleColonIdx >= endTag) {
                doubleColonIdx = -1;
            }
            String key = doubleColonIdx >= 0 ? sb.substring(begTag + 2, doubleColonIdx) : sb.substring(begTag + 2, endTag);
            Object obj = dict.get(key);
            if (doubleColonIdx < 0) {
                String replacement = obj == null ? "" : String.valueOf(obj);
                sb.replace(begTag, endTag + 2, replacement);
                index = begTag + replacement.length();
                continue;
            }
            char ch = sb.charAt(doubleColonIdx + 2);
            if (ch == '?') {
                index = Template.conditionalInclude(sb, begTag, doubleColonIdx, endTag, obj, false);
                continue;
            }
            if (ch == '!') {
                index = Template.conditionalInclude(sb, begTag, doubleColonIdx, endTag, obj, true);
                continue;
            }
            if (obj == null) {
                sb.delete(begTag, endTag + 2);
                index = begTag;
                continue;
            }
            if (ch == '*') {
                String toInsert;
                extra = sb.substring(doubleColonIdx + 3, endTag);
                sb.delete(begTag, endTag + 2);
                index = begTag;
                if (obj instanceof List) {
                    List list = (List)obj;
                    for (Object subObj : list) {
                        String toInsert2 = subObj instanceof Map ? Template.subDictIntoString(extra, (Map)subObj) : String.valueOf(subObj);
                        sb.insert(index, toInsert2);
                        index += toInsert2.length();
                    }
                    continue;
                }
                if (obj instanceof Map) {
                    toInsert = Template.subDictIntoString(extra, (Map)obj);
                    sb.insert(index, toInsert);
                    index += toInsert.length();
                    continue;
                }
                toInsert = Template.subDictIntoString(extra, dict);
                sb.insert(index, toInsert);
                index += toInsert.length();
                continue;
            }
            extra = sb.substring(doubleColonIdx + 2, endTag);
            String replacement = extra.equalsIgnoreCase("URLEncodeComponent") ? StringUtils.encodeURLComponent((String)String.valueOf(obj)) : (extra.equalsIgnoreCase("URLEncodePath") ? StringUtils.encodeURLPath((String)String.valueOf(obj)) : (extra.equalsIgnoreCase("CGIEscape") ? StringUtils.cgiEscape((String)String.valueOf(obj)) : (extra.equalsIgnoreCase("SQLString") ? StringUtils.sqlEscape((String)String.valueOf(obj)) : String.valueOf(obj))));
            sb.replace(begTag, endTag + 2, replacement);
            index = begTag + replacement.length();
        }
        return sb.toString();
    }

    private static int conditionalInclude(StringBuilder sb, int begTag, int doubleColonIdx, int endTag, Object value, boolean notEqual) {
        int firstColon = sb.indexOf(":", doubleColonIdx + 3);
        if (firstColon >= endTag) {
            firstColon = -1;
        }
        if (firstColon < 0) {
            sb.delete(begTag, endTag + 2);
            return begTag;
        }
        boolean matches = false;
        if (notEqual) {
            matches = value == null || !sb.substring(doubleColonIdx + 3, firstColon).equals(String.valueOf(value));
        } else {
            boolean bl = matches = value != null && sb.substring(doubleColonIdx + 3, firstColon).equals(String.valueOf(value));
        }
        if (matches) {
            sb.delete(endTag, endTag + 2);
            sb.delete(begTag, firstColon + 1);
            return begTag;
        }
        sb.delete(begTag, endTag + 2);
        return begTag;
    }
}

