/*
 * Decompiled with CFR 0.152.
 */
package net.handle.api;

import java.security.PrivateKey;
import net.handle.api.HSAdapter;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AddValueRequest;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ClientSessionTracker;
import net.handle.hdllib.Common;
import net.handle.hdllib.CreateHandleRequest;
import net.handle.hdllib.DeleteHandleRequest;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ModifyValueRequest;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.RemoveValueRequest;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.Resolver;
import net.handle.hdllib.SecretKeyAuthenticationInfo;
import net.handle.hdllib.SessionSetupInfo;
import net.handle.hdllib.Util;

class GenericHSAdapter
implements HSAdapter {
    private String adminHandle = null;
    private Resolver resolver = new Resolver();
    private ClientSessionTracker sessionTracker = null;
    private AuthenticationInfo authenticationInfo = null;
    private boolean isAuthenticated = false;

    GenericHSAdapter() {
        String traceFlag = System.getProperty("handletrace", "no");
        this.resolver.getResolver().traceMessages = traceFlag.equals("on") || traceFlag.startsWith("t") || traceFlag.startsWith("y");
        this.useSessions();
    }

    GenericHSAdapter(String adminHandle, int keyIndex, byte[] privateKey, byte[] cipher) throws HandleException {
        this();
        this.adminHandle = adminHandle;
        try {
            byte[] buffer = Util.decrypt(privateKey, cipher);
            PrivateKey key = Util.getPrivateKeyFromBytes(buffer, 0);
            this.authenticationInfo = new PublicKeyAuthenticationInfo(Util.encodeString(adminHandle), keyIndex, key);
            if (!this.resolver.checkAuthentication(this.authenticationInfo)) {
                throw new HandleException(8, "Invalid credentials");
            }
        }
        catch (Exception ex) {
            if (ex instanceof HandleException) {
                throw (HandleException)ex;
            }
            throw new HandleException(8, "Error authenticating handle administrator");
        }
        this.isAuthenticated = true;
        this.useSessions();
    }

    GenericHSAdapter(String adminHandle, int keyIndex, byte[] secretKey) throws HandleException {
        this();
        this.adminHandle = adminHandle;
        try {
            this.authenticationInfo = new SecretKeyAuthenticationInfo(Util.encodeString(adminHandle), keyIndex, secretKey);
            if (!this.resolver.checkAuthentication(this.authenticationInfo)) {
                throw new HandleException(8, "Invalid credentials");
            }
        }
        catch (Exception ex) {
            if (ex instanceof HandleException) {
                throw (HandleException)ex;
            }
            throw new HandleException(8, "Error authenticating handle administrator");
        }
        this.isAuthenticated = true;
        this.useSessions();
    }

    @Override
    public void addHandleValues(String handle, HandleValue[] values) throws HandleException {
        if (!this.isAuthenticated) {
            throw new HandleException(8, "Error authenticating handle administrator");
        }
        if (values == null || values.length <= 0) {
            return;
        }
        HandleException exception = null;
        try {
            AddValueRequest request = new AddValueRequest(Util.encodeString(handle), values, this.authenticationInfo);
            AbstractResponse response = this.resolver.getResolver().processRequest(request);
            if (response.responseCode != 1) {
                exception = GenericHSAdapter.errorToException(response, handle);
            }
        }
        catch (Throwable e) {
            exception = new HandleException(1, "Error adding handle records");
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public HandleValue createAdminValue(String adminHandleForValue, int keyIndex, int index) throws HandleException {
        AdminRecord adminRecord = new AdminRecord(Util.encodeString(adminHandleForValue), keyIndex, true, true, true, true, true, true, true, true, true, true, true, true);
        return new HandleValue(index, Common.ADMIN_TYPE, Encoder.encodeAdminRecord(adminRecord), 0, 86400, 0, null, true, true, true, false);
    }

    @Override
    public void createHandle(String handle, HandleValue[] values) throws HandleException {
        if (!this.isAuthenticated) {
            throw new HandleException(8, "Error authenticating handle administrator");
        }
        if (values == null || values.length <= 0) {
            throw new HandleException(0, "Handle values not found");
        }
        HandleException exception = null;
        try {
            CreateHandleRequest request = new CreateHandleRequest(Util.encodeString(handle), values, this.authenticationInfo);
            AbstractResponse response = this.resolver.getResolver().processRequest(request);
            if (response.responseCode != 1) {
                exception = GenericHSAdapter.errorToException(response, handle);
            }
        }
        catch (Throwable e) {
            exception = new HandleException(1, "Error creating handle");
            try {
                exception.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public HandleValue createHandleValue(int index, String type, String data) throws HandleException {
        return new HandleValue(index, Util.encodeString(type), Util.encodeString(data), 0, 86400, 0, null, true, true, true, false);
    }

    @Override
    public void deleteHandle(String handle) throws HandleException {
        if (!this.isAuthenticated) {
            throw new HandleException(8, "Error authenticating handle administrator");
        }
        HandleException exception = null;
        try {
            DeleteHandleRequest request = new DeleteHandleRequest(Util.encodeString(handle), this.authenticationInfo);
            AbstractResponse response = this.resolver.getResolver().processRequest(request);
            if (response.responseCode != 1) {
                exception = GenericHSAdapter.errorToException(response, handle);
            }
        }
        catch (Throwable e) {
            exception = new HandleException(1, "Error deleting handle");
            try {
                exception.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void deleteHandleValues(String handle, HandleValue[] values) throws HandleException {
        if (!this.isAuthenticated) {
            throw new HandleException(8, "Error authenticating handle administrator");
        }
        if (values == null || values.length <= 0) {
            throw new HandleException(0, "No values given in deleteHandleValues");
        }
        HandleException exception = null;
        try {
            int[] indexes = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                indexes[i] = values[i].getIndex();
            }
            RemoveValueRequest request = new RemoveValueRequest(Util.encodeString(handle), indexes, this.authenticationInfo);
            AbstractResponse response = this.resolver.getResolver().processRequest(request);
            if (response.responseCode != 1) {
                exception = GenericHSAdapter.errorToException(response, handle);
            }
        }
        catch (Throwable e) {
            exception = new HandleException(1, "Error deleting handle records");
            try {
                exception.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public HandleValue[] resolveHandle(String handle, String[] types, int[] indexes) throws HandleException {
        return this.resolveHandle(handle, types, indexes, false);
    }

    @Override
    public HandleValue[] resolveHandle(String handle, String[] types, int[] indexes, boolean auth) throws HandleException {
        byte[][] filters = null;
        HandleException exception = null;
        if (types == null) {
            types = new String[]{};
        }
        if (indexes == null) {
            indexes = new int[]{};
        }
        if (types.length > 0) {
            filters = new byte[types.length][];
            for (int i = 0; i < types.length; ++i) {
                filters[i] = Util.encodeString(types[i]);
            }
        }
        try {
            ResolutionRequest request = new ResolutionRequest(Util.encodeString(handle), filters, indexes, this.authenticationInfo);
            if (this.authenticationInfo != null && this.isAuthenticated) {
                request.ignoreRestrictedValues = false;
            }
            request.authoritative = auth;
            AbstractResponse response = this.resolver.getResolver().processRequest(request);
            if (response.responseCode == 1) {
                return ((ResolutionResponse)response).getHandleValues();
            }
            exception = GenericHSAdapter.errorToException(response, handle);
        }
        catch (Throwable e) {
            exception = new HandleException(1, "Error resolving handle");
            try {
                exception.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        throw exception;
    }

    @Override
    public void setTcpTimeout(int newTcpTimeout) {
        this.resolver.getResolver().setTcpTimeout(newTcpTimeout);
    }

    @Override
    public int getTcpTimeout() {
        return this.resolver.getResolver().getTcpTimeout();
    }

    @Override
    public void setUseUDP(boolean useUDP) {
        if (useUDP) {
            this.resolver.getResolver().setPreferredProtocols(new int[]{0, 1, 2});
        } else {
            this.resolver.getResolver().setPreferredProtocols(new int[]{1, 2});
        }
    }

    @Override
    public void updateHandleValues(String handle, HandleValue[] values) throws HandleException {
        if (!this.isAuthenticated) {
            throw new HandleException(8, "Error authenticating handle administrator");
        }
        if (values == null || values.length <= 0) {
            return;
        }
        HandleException exception = null;
        try {
            ModifyValueRequest request = new ModifyValueRequest(Util.encodeString(handle), values, this.authenticationInfo);
            AbstractResponse response = this.resolver.getResolver().processRequest(request);
            if (response.responseCode != 1) {
                exception = GenericHSAdapter.errorToException(response, handle);
            }
        }
        catch (Throwable e) {
            exception = new HandleException(1, "Error updating handle records");
            try {
                exception.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void useSessions() {
        if (!this.isAuthenticated) {
            return;
        }
        this.sessionTracker = new ClientSessionTracker();
        try {
            this.sessionTracker.setSessionSetupInfo(new SessionSetupInfo());
        }
        catch (Exception e) {
            System.err.println("**** Sessions not activated for " + this.adminHandle);
        }
        this.resolver.getResolver().setSessionTracker(this.sessionTracker);
    }

    private static HandleException errorToException(AbstractResponse response, String handle) {
        if (response.responseCode == 101) {
            return new HandleException(5, "Handle already exists");
        }
        if (response.responseCode == 100) {
            return new HandleException(9, "Handle not found");
        }
        if (response.responseCode == 201) {
            return new HandleException(0, "Handle value already exists");
        }
        if (response.responseCode == 202) {
            return new HandleException(0, "Invalid handle value");
        }
        if (response.responseCode == 102) {
            return new HandleException(1, "Invalid handle value");
        }
        if (response.responseCode >= 400) {
            return new HandleException(8, "Error authenticating handle administrator");
        }
        if (response.responseCode == 403) {
            return new HandleException(8, "Error authenticating handle administrator");
        }
        if (response.responseCode == 401) {
            return new HandleException(10, "Insufficient handle permissions");
        }
        if (response.responseCode == 200) {
            return new HandleException(0, "Handle values not found");
        }
        return new HandleException(15, "Unknown handle error");
    }
}

