/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch;

import java.util.ArrayList;
import java.util.List;
import net.handle.apps.batch.BatchUtil;
import net.handle.apps.batch.HandleRecordFilter;
import net.handle.apps.batch.HandleRecordOperationInterface;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.SiteInfo;

public class BatchHandleProcessor {
    private final List<String> handles;
    private final HandleResolver resolver;
    private final AuthenticationInfo authInfoForProcessing;
    private final AuthenticationInfo authInfoForResolution;
    private final SiteInfo site;
    private final List<String> errorHandles;
    private boolean skipResolution;

    public BatchHandleProcessor(List<String> handles, HandleResolver resolver, AuthenticationInfo authInfoForResolutionAndProcessing, SiteInfo site) {
        this(handles, resolver, authInfoForResolutionAndProcessing, authInfoForResolutionAndProcessing, site);
    }

    public BatchHandleProcessor(List<String> handles, HandleResolver resolver, AuthenticationInfo authInfoForResolution, AuthenticationInfo authInfoForProcessing, SiteInfo site) {
        this.handles = handles;
        this.resolver = resolver;
        this.authInfoForResolution = authInfoForResolution;
        this.authInfoForProcessing = authInfoForProcessing;
        this.site = site;
        this.errorHandles = new ArrayList<String>();
    }

    public BatchHandleProcessor(List<String> handles, HandleResolver resolver, AuthenticationInfo authInfoForResolution, AuthenticationInfo authInfoForProcessing, SiteInfo site, boolean skipResolution) {
        this.handles = handles;
        this.resolver = resolver;
        this.authInfoForResolution = authInfoForResolution;
        this.authInfoForProcessing = authInfoForProcessing;
        this.site = site;
        this.errorHandles = new ArrayList<String>();
        this.skipResolution = skipResolution;
    }

    public void process(HandleRecordOperationInterface recordProcessor, HandleRecordFilter processFilter) {
        int count = 0;
        for (String handle : this.handles) {
            try {
                if ("".equals(handle)) continue;
                HandleValue[] values = null;
                if (!this.skipResolution) {
                    values = BatchUtil.resolveHandle(handle, this.resolver, this.authInfoForResolution);
                }
                if (processFilter != null) {
                    boolean skip;
                    boolean bl = skip = !processFilter.accept(values);
                    if (skip) continue;
                }
                recordProcessor.process(handle, values, this.resolver, this.authInfoForProcessing, this.site);
            }
            catch (HandleException e) {
                System.err.println("Exception processing " + handle);
                e.printStackTrace();
                this.errorHandles.add(handle);
            }
            System.out.println(count + ": " + handle);
            ++count;
        }
    }

    public void process(HandleRecordOperationInterface recordProcessor) {
        this.process(recordProcessor, null);
    }

    public List<String> getErrorHandles() {
        return this.errorHandles;
    }

    public List<String> filter(HandleRecordFilter filter) throws HandleException {
        ArrayList<String> result = new ArrayList<String>();
        int count = 0;
        for (String handle : this.handles) {
            HandleValue[] values = this.resolver.resolveHandle(handle);
            if (filter.accept(values)) {
                result.add(handle);
            }
            System.out.println(count++);
        }
        return result;
    }
}

