/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import net.handle.apps.batch.ListHandlesUtil;
import net.handle.apps.batch.ListPrefixesUtil;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AddValueRequest;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.CreateHandleRequest;
import net.handle.hdllib.DeleteHandleRequest;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleSignature;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.HomeNaRequest;
import net.handle.hdllib.ModifyValueRequest;
import net.handle.hdllib.RemoveValueRequest;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.UnhomeNaRequest;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.hdllib.trust.HandleSigner;
import net.handle.hdllib.trust.JsonWebSignature;

public class BatchUtil {
    public static SiteInfo getSite(String siteHandle, HandleResolver resolver) throws HandleException {
        if (siteHandle.contains(":")) {
            String[] tokens = siteHandle.split(":");
            int index = Integer.parseInt(tokens[0]);
            String handle = tokens[1];
            ResolutionRequest svcReq = new ResolutionRequest(Util.encodeString(handle), null, null, null);
            svcReq.authoritative = true;
            AbstractResponse response = resolver.processRequest(svcReq);
            BatchUtil.throwIfNotSuccess(response);
            if (!(response instanceof ResolutionResponse)) {
                throw new HandleException(1, AbstractMessage.getResponseCodeMessage(response.responseCode));
            }
            ResolutionResponse resp = (ResolutionResponse)response;
            HandleValue[] values = resp.getHandleValues();
            HandleValue siteHandleValue = BatchUtil.getHandleValueAtIndex(values, index);
            if (siteHandleValue == null) {
                throw new InvalidParameterException("There is no siteInfo at index " + index + " on handle record " + handle);
            }
            SiteInfo site = new SiteInfo();
            try {
                Encoder.decodeSiteInfoRecord(siteHandleValue.getData(), 0, site);
            }
            catch (HandleException e) {
                throw new InvalidParameterException("Could not decode a siteInfo at index " + index + " on handle record " + handle);
            }
            return site;
        }
        ResolutionRequest svcReq = new ResolutionRequest(Util.encodeString(siteHandle), null, null, null);
        svcReq.authoritative = true;
        AbstractResponse response = resolver.processRequest(svcReq);
        BatchUtil.throwIfNotSuccess(response);
        if (!(response instanceof ResolutionResponse)) {
            throw new HandleException(1, AbstractMessage.getResponseCodeMessage(response.responseCode));
        }
        ResolutionResponse resp = (ResolutionResponse)response;
        HandleValue[] values = resp.getHandleValues();
        SiteInfo site = BatchUtil.getFirstPrimarySite(values);
        if (site == null) {
            site = BatchUtil.getFirstPrimarySiteFromHserv(values, resolver);
        }
        return site;
    }

    public static HandleValue getHandleValueAtIndex(HandleValue[] handleValues, int index) {
        for (HandleValue value : handleValues) {
            if (value.getIndex() != index) continue;
            return value;
        }
        return null;
    }

    public static SiteInfo getFirstPrimarySiteFromHserv(HandleValue[] values, HandleResolver resolver) throws HandleException {
        List<HandleValue> servs = BatchUtil.getValuesOfType(values, "HS_SERV");
        if (servs == null) {
            return null;
        }
        for (HandleValue serv : servs) {
            ResolutionResponse resp;
            HandleValue[] siteValues;
            SiteInfo site;
            String siteHandle = serv.getDataAsString();
            ResolutionRequest svcReq = new ResolutionRequest(Util.encodeString(siteHandle), null, null, null);
            svcReq.authoritative = true;
            AbstractResponse response = resolver.processRequest(svcReq);
            if (!(response instanceof ResolutionResponse) || (site = BatchUtil.getFirstPrimarySite(siteValues = (resp = (ResolutionResponse)response).getHandleValues())) == null) continue;
            return site;
        }
        return null;
    }

    public static SiteInfo getFirstPrimarySite(HandleValue[] values) {
        SiteInfo[] sites = Util.getSitesFromValues(values);
        if (sites == null) {
            return null;
        }
        for (SiteInfo site : sites) {
            if (!site.isPrimary) continue;
            return site;
        }
        return null;
    }

    public static List<String> listAllHandlesOnSite(SiteInfo site, HandleResolver resolver, AuthenticationInfo authInfo) throws HandleException {
        ArrayList<String> result = new ArrayList<String>();
        ListPrefixesUtil listUtil = new ListPrefixesUtil(site, authInfo, resolver);
        List<String> allPrefixes = listUtil.getAllPrefixes();
        for (String prefix : allPrefixes) {
            List<String> handlesUnderPrefix = BatchUtil.listHandles(prefix, site, resolver, authInfo);
            result.addAll(handlesUnderPrefix);
        }
        return result;
    }

    public static List<String> listPrefixesOnSite(SiteInfo site, HandleResolver resolver, AuthenticationInfo authInfo) throws HandleException {
        ListPrefixesUtil listUtil = new ListPrefixesUtil(site, authInfo, resolver);
        List<String> allPrefixes = listUtil.getAllPrefixes();
        return allPrefixes;
    }

    public static List<String> listHandles(String prefix, SiteInfo site, HandleResolver resolver, AuthenticationInfo authInfo) throws HandleException {
        ListHandlesUtil listUtil = new ListHandlesUtil(site, authInfo, resolver);
        List<String> result = listUtil.getAllHandles(prefix);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getHandlesFromFile(String fileName) throws FileNotFoundException {
        try (Scanner sc = new Scanner(new File(fileName), "UTF-8");){
            ArrayList<String> lines = new ArrayList<String>();
            while (sc.hasNextLine()) {
                lines.add(sc.nextLine());
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getLinesFromFile(String fileName) throws FileNotFoundException {
        try (Scanner sc = new Scanner(new File(fileName), "UTF-8");){
            ArrayList<String> lines = new ArrayList<String>();
            while (sc.hasNextLine()) {
                lines.add(sc.nextLine());
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
    }

    public static void writeHandlesToFile(List<String> handles, String fileName) throws IOException {
        FileWriter writer = new FileWriter(fileName);
        for (String handle : handles) {
            writer.write(handle + "\n");
        }
        writer.close();
    }

    public static void writeHandlesToConsole(List<String> handles) {
        for (String handle : handles) {
            System.out.println(handle);
        }
    }

    public static HandleValue[] addValue(HandleValue[] values, HandleValue value) {
        ArrayList<HandleValue> augmentedValues = new ArrayList<HandleValue>();
        augmentedValues.addAll(Arrays.asList(values));
        augmentedValues.add(value);
        HandleValue[] result = augmentedValues.toArray(new HandleValue[0]);
        return result;
    }

    public static int getNextIndex(HandleValue[] values, int start) {
        int i = 0;
        while (i < values.length) {
            HandleValue val = values[i];
            if (val.getIndex() == start) {
                ++start;
                i = 0;
                continue;
            }
            ++i;
        }
        return start;
    }

    public static int lowestAvailableIndex(HandleValue[] values) {
        ArrayList<Integer> usedIndexes = new ArrayList<Integer>();
        for (HandleValue value : values) {
            usedIndexes.add(value.getIndex());
        }
        return BatchUtil.lowestAvailableIndex(usedIndexes);
    }

    public static int lowestAvailableIndex(List<Integer> usedIndexes) {
        if (usedIndexes.size() == 0) {
            return 1;
        }
        if (usedIndexes.size() == 1) {
            int index = usedIndexes.get(0);
            if (index == 0) {
                throw new IllegalArgumentException("Handle Values may not have an index of zero");
            }
            if (index > 1) {
                return 1;
            }
            return 2;
        }
        Collections.sort(usedIndexes);
        for (int i = 0; i < usedIndexes.size(); ++i) {
            int indexA = usedIndexes.get(i);
            if (i == 0) {
                if (indexA == 0) {
                    throw new IllegalArgumentException("Handle Values may not have an index of zero");
                }
                if (indexA > 1) {
                    return 1;
                }
            }
            if (usedIndexes.size() - 1 == i) {
                return indexA + 1;
            }
            int indexB = usedIndexes.get(i + 1);
            if (indexB - indexA <= 1) continue;
            return indexA + 1;
        }
        return -1;
    }

    public static boolean hasHandleValueOfType(HandleValue[] values, String type) {
        for (HandleValue value : values) {
            byte[] typeBytes = value.getType();
            String valueType = Util.decodeString(typeBytes);
            if (!type.equals(valueType)) continue;
            return true;
        }
        return false;
    }

    public static List<HandleValue> getValuesOfType(HandleValue[] values, String type) {
        ArrayList<HandleValue> result = new ArrayList<HandleValue>();
        for (HandleValue value : values) {
            byte[] typeBytes = value.getType();
            String valueType = Util.decodeString(typeBytes);
            if (!type.equals(valueType)) continue;
            result.add(value);
        }
        return result;
    }

    public static List<HandleValue> getValuesNotOfType(HandleValue[] values, String type) {
        ArrayList<HandleValue> result = new ArrayList<HandleValue>();
        for (HandleValue value : values) {
            byte[] typeBytes = value.getType();
            String valueType = Util.decodeString(typeBytes);
            if (type.equals(valueType)) continue;
            result.add(value);
        }
        return result;
    }

    public static AbstractResponse addHandleValue(String handle, HandleValue value, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        byte[] handleBytes = Util.encodeString(handle);
        AddValueRequest request = new AddValueRequest(handleBytes, value, authInfo);
        AbstractResponse response = resolver.sendRequestToSite(request, site);
        return response;
    }

    public static HandleValue[] resolveHandle(String handle, HandleResolver resolver, AuthenticationInfo authInfo) throws HandleException {
        byte[] handleBytes = Util.encodeString(handle);
        ResolutionRequest request = new ResolutionRequest(handleBytes, null, null, authInfo);
        if (authInfo != null) {
            request.ignoreRestrictedValues = false;
        }
        AbstractResponse response = resolver.processRequest(request);
        BatchUtil.throwIfNotSuccess(response);
        if (response instanceof ResolutionResponse) {
            ResolutionResponse resResponse = (ResolutionResponse)response;
            return resResponse.getHandleValues();
        }
        throw new HandleException(1, AbstractMessage.getResponseCodeMessage(response.responseCode));
    }

    public static HandleValue[] resolveHandleFromSite(String handle, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        byte[] handleBytes = Util.encodeString(handle);
        ResolutionRequest request = new ResolutionRequest(handleBytes, null, null, authInfo);
        if (authInfo != null) {
            request.ignoreRestrictedValues = false;
        }
        AbstractResponse response = resolver.sendRequestToSite(request, site);
        BatchUtil.throwIfNotSuccess(response);
        if (response instanceof ResolutionResponse) {
            ResolutionResponse resResponse = (ResolutionResponse)response;
            return resResponse.getHandleValues();
        }
        throw new HandleException(1, AbstractMessage.getResponseCodeMessage(response.responseCode));
    }

    public static AbstractResponse addAliasToHandleRecord(String handle, String alias, int index, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        HandleValue aliasValue = new HandleValue(index, Util.encodeString("HS_ALIAS"), Util.encodeString(alias));
        AbstractResponse response = BatchUtil.addHandleValue(handle, aliasValue, resolver, authInfo, site);
        return response;
    }

    public static AbstractResponse modifyHandleValue(String handle, HandleValue value, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        byte[] handleBytes = Util.encodeString(handle);
        ModifyValueRequest request = new ModifyValueRequest(handleBytes, value, authInfo);
        AbstractResponse response = resolver.sendRequestToSite(request, site);
        return response;
    }

    public static AbstractResponse updateEntireHandleRecord(String handle, List<HandleValue> values, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        byte[] handleBytes = Util.encodeString(handle);
        CreateHandleRequest request = new CreateHandleRequest(handleBytes, values.toArray(new HandleValue[values.size()]), authInfo);
        request.overwriteWhenExists = true;
        AbstractResponse response = resolver.sendRequestToSite(request, site);
        return response;
    }

    public static AbstractResponse removeValueRequest(String handle, HandleValue value, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        int indexToRemove = value.getIndex();
        byte[] handleBytes = Util.encodeString(handle);
        RemoveValueRequest request = new RemoveValueRequest(handleBytes, indexToRemove, authInfo);
        AbstractResponse response = resolver.sendRequestToSite(request, site);
        return response;
    }

    public static AbstractResponse removeValuesAtIndices(String handle, int[] indicesToRemove, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        byte[] handleBytes = Util.encodeString(handle);
        RemoveValueRequest request = new RemoveValueRequest(handleBytes, indicesToRemove, authInfo);
        AbstractResponse response = resolver.sendRequestToSite(request, site);
        return response;
    }

    public static HandleValue[] signHandleValues(HandleValue[] values, String handleToCreate, String handleOfSigner, int indexOfSigner, PrivateKey privateKeyOfSigner) throws Exception {
        HandleValue digestsValue = HandleSignature.createDigestsValue(400, handleToCreate, values);
        ValueReference signer = new ValueReference(Util.encodeString(handleOfSigner), indexOfSigner);
        String alg = null;
        HandleValue signatureValue = HandleSignature.createSignatureValue(401, handleToCreate, signer, alg, privateKeyOfSigner, digestsValue);
        ArrayList<HandleValue> augmentedValues = new ArrayList<HandleValue>();
        augmentedValues.addAll(Arrays.asList(values));
        augmentedValues.add(digestsValue);
        augmentedValues.add(signatureValue);
        values = augmentedValues.toArray(new HandleValue[0]);
        return values;
    }

    public static HandleValue[] signHandleValuesWithJws(HandleValue[] values, String handleToSign, String handleOfSigner, int indexOfSigner, PrivateKey privateKeyOfSigner, List<String> chain) throws Exception {
        ArrayList<HandleValue> valuesList = new ArrayList<HandleValue>();
        valuesList.addAll(Arrays.asList(values));
        long ONE_DAY = 86400000L;
        long ONE_YEAR = ONE_DAY * 366L;
        HandleSigner handleSigner = new HandleSigner();
        long now = System.currentTimeMillis();
        long notBefore = now - ONE_DAY;
        long expiration = now + ONE_YEAR * 2L;
        ValueReference signer = new ValueReference(handleOfSigner, indexOfSigner);
        JsonWebSignature jws = handleSigner.signHandleValues(handleToSign, valuesList, signer, privateKeyOfSigner, chain, notBefore / 1000L, expiration / 1000L);
        HandleValue signatureValue = new HandleValue(401, Util.encodeString("HS_SIGNATURE"), Util.encodeString(jws.serialize()));
        valuesList.add(signatureValue);
        values = valuesList.toArray(new HandleValue[0]);
        return values;
    }

    public static HandleValue[] createExampleHandleValues(String handle, String url, String adminHandle, int adminIndex) {
        HandleValue[] values = new HandleValue[]{new HandleValue(2, Util.encodeString("URL"), Util.encodeString(url)), new HandleValue()};
        values[1].setIndex(100);
        values[1].setType(Common.ADMIN_TYPE);
        values[1].setData(Encoder.encodeAdminRecord(new AdminRecord(Util.encodeString(adminHandle), adminIndex, true, true, true, true, true, true, true, true, true, true, true, true)));
        return values;
    }

    public static AbstractResponse deleteHandleRecord(String handle, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        byte[] handleBytes = Util.encodeString(handle);
        DeleteHandleRequest request = new DeleteHandleRequest(handleBytes, authInfo);
        AbstractResponse response = resolver.sendRequestToSite(request, site);
        return response;
    }

    public static AbstractResponse createHandleRecord(String handle, HandleValue[] values, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        byte[] handleBytes = Util.encodeString(handle);
        CreateHandleRequest request = new CreateHandleRequest(handleBytes, values, authInfo);
        AbstractResponse response = resolver.sendRequestToSite(request, site);
        return response;
    }

    public static AbstractResponse updateEntireHandleRecord(String handle, HandleValue[] values, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        byte[] handleBytes = Util.encodeString(handle);
        CreateHandleRequest request = new CreateHandleRequest(handleBytes, values, authInfo);
        request.overwriteWhenExists = true;
        AbstractResponse response = resolver.sendRequestToSite(request, site);
        return response;
    }

    public static AbstractResponse unhomePrefix(String prefix, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        byte[] prefixBytes = Util.encodeString(prefix);
        UnhomeNaRequest request = new UnhomeNaRequest(prefixBytes, authInfo);
        AbstractResponse response = resolver.sendRequestToSite(request, site);
        return response;
    }

    public static AbstractResponse homePrefix(String prefix, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        byte[] prefixBytes = Util.encodeString(prefix);
        HomeNaRequest request = new HomeNaRequest(prefixBytes, authInfo);
        AbstractResponse response = resolver.sendRequestToSite(request, site);
        return response;
    }

    public static void throwIfNotSuccess(AbstractResponse response) throws HandleException {
        if (response.responseCode != 1) {
            throw new HandleException(1, response.toString());
        }
    }
}

