/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.handle.apps.batch.BatchUtil;
import net.handle.apps.batch.HandleRecordFilter;
import net.handle.apps.batch.HandleRecordOperationInterface;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.SiteInfo;

public class ParallelBatchHandleProcessor {
    private final List<String> handles;
    private final HandleResolver resolver;
    private final AuthenticationInfo authInfoForResolution;
    private final AuthenticationInfo authInfoForProcessing;
    private final SiteInfo site;
    private final List<String> errorHandles;
    private final List<Exception> exceptions;
    private final AtomicInteger atomicCount;
    private final ExecutorService executor;
    private boolean verbose = true;
    ResolutionType resolutionType = ResolutionType.GLOBAL;

    public ParallelBatchHandleProcessor(boolean verbose, List<String> handles, HandleResolver resolver, AuthenticationInfo authInfoForResolutionAndProcessing, SiteInfo site, int numThreads) {
        this(handles, resolver, authInfoForResolutionAndProcessing, site, numThreads);
        this.verbose = verbose;
    }

    public ParallelBatchHandleProcessor(boolean verbose, List<String> handles, HandleResolver resolver, AuthenticationInfo authInfoForResolutionAndProcessing, SiteInfo site, int numThreads, boolean resolveAtSite) {
        this(handles, resolver, authInfoForResolutionAndProcessing, site, numThreads, resolveAtSite);
        this.verbose = verbose;
    }

    public ParallelBatchHandleProcessor(boolean verbose, List<String> handles, HandleResolver resolver, AuthenticationInfo authInfoForResolution, AuthenticationInfo authInfoForProcessing, SiteInfo site, int numThreads, boolean resolveAtSite) {
        this(handles, resolver, authInfoForResolution, authInfoForProcessing, site, numThreads, resolveAtSite);
        this.verbose = verbose;
    }

    public ParallelBatchHandleProcessor(List<String> handles, HandleResolver resolver, AuthenticationInfo authInfoForResolutionAndProcessing, SiteInfo site, int numThreads) {
        this(handles, resolver, authInfoForResolutionAndProcessing, site, numThreads, false);
    }

    public ParallelBatchHandleProcessor(List<String> handles, HandleResolver resolver, AuthenticationInfo authInfoForResolutionAndProcessing, SiteInfo site, int numThreads, boolean resolveAtSite) {
        this(handles, resolver, authInfoForResolutionAndProcessing, authInfoForResolutionAndProcessing, site, numThreads, resolveAtSite);
    }

    public ParallelBatchHandleProcessor(List<String> handles, HandleResolver resolver, AuthenticationInfo authInfoForResolution, AuthenticationInfo authInfoForProcessing, SiteInfo site, int numThreads, boolean resolveAtSite) {
        this(handles, resolver, authInfoForResolution, authInfoForProcessing, site, numThreads, resolveAtSite ? ResolutionType.SPECIFIC_SITE : ResolutionType.GLOBAL);
    }

    public ParallelBatchHandleProcessor(List<String> handles, HandleResolver resolver, AuthenticationInfo authInfoForResolution, AuthenticationInfo authInfoForProcessing, SiteInfo site, int numThreads, ResolutionType resolutionType) {
        this.handles = handles;
        this.resolver = resolver;
        this.authInfoForResolution = authInfoForResolution;
        this.authInfoForProcessing = authInfoForProcessing;
        this.site = site;
        this.errorHandles = Collections.synchronizedList(new ArrayList());
        this.exceptions = Collections.synchronizedList(new ArrayList());
        this.executor = Executors.newFixedThreadPool(numThreads);
        this.atomicCount = new AtomicInteger(0);
        this.resolutionType = resolutionType;
    }

    public void process(HandleRecordOperationInterface recordProcessor) {
        for (String handle : this.handles) {
            if ("".equals(handle)) continue;
            SingleHandleTask task = new SingleHandleTask(handle, recordProcessor);
            this.executor.execute(task);
        }
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            System.out.println("error shutting down");
        }
    }

    public void process(HandleRecordOperationInterface recordProcessor, HandleRecordFilter processFilter) {
        for (String handle : this.handles) {
            if ("".equals(handle)) continue;
            SingleHandleTask task = new SingleHandleTask(handle, recordProcessor, processFilter);
            this.executor.execute(task);
        }
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            System.out.println("error shutting down");
        }
    }

    public List<String> getErrorHandles() {
        return this.errorHandles;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public class SingleHandleTask
    implements Runnable {
        private final String handle;
        private final HandleRecordOperationInterface recordProcessor;
        private HandleRecordFilter processFilter;

        public SingleHandleTask(String handle, HandleRecordOperationInterface recordProcessor) {
            this.handle = handle;
            this.recordProcessor = recordProcessor;
        }

        public SingleHandleTask(String handle, HandleRecordOperationInterface recordProcessor, HandleRecordFilter processFilter) {
            this.handle = handle;
            this.recordProcessor = recordProcessor;
            this.processFilter = processFilter;
        }

        @Override
        public void run() {
            try {
                int count = ParallelBatchHandleProcessor.this.atomicCount.getAndIncrement();
                if (ParallelBatchHandleProcessor.this.verbose) {
                    System.out.println(count + ": " + this.handle);
                }
                HandleValue[] values = ParallelBatchHandleProcessor.this.resolutionType == ResolutionType.SPECIFIC_SITE ? BatchUtil.resolveHandleFromSite(this.handle, ParallelBatchHandleProcessor.this.resolver, ParallelBatchHandleProcessor.this.authInfoForResolution, ParallelBatchHandleProcessor.this.site) : (ParallelBatchHandleProcessor.this.resolutionType == ResolutionType.GLOBAL ? BatchUtil.resolveHandle(this.handle, ParallelBatchHandleProcessor.this.resolver, ParallelBatchHandleProcessor.this.authInfoForResolution) : null);
                if (this.processFilter != null && !this.processFilter.accept(values)) {
                    return;
                }
                this.recordProcessor.process(this.handle, values, ParallelBatchHandleProcessor.this.resolver, ParallelBatchHandleProcessor.this.authInfoForProcessing, ParallelBatchHandleProcessor.this.site);
            }
            catch (HandleException e) {
                System.err.println("Exception processing " + this.handle);
                e.printStackTrace();
                ParallelBatchHandleProcessor.this.exceptions.add(e);
                ParallelBatchHandleProcessor.this.errorHandles.add(this.handle);
            }
        }
    }

    public static enum ResolutionType {
        SPECIFIC_SITE,
        GLOBAL,
        NONE;

    }
}

