/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch.filters;

import java.util.List;
import net.handle.apps.batch.HandleRecordFilter;
import net.handle.hdllib.HandleValue;

public class HasValuesFilter
implements HandleRecordFilter {
    List<TypeAndValue> typeAndValueList;

    public HasValuesFilter(List<TypeAndValue> typeAndValueList) {
        this.typeAndValueList = typeAndValueList;
    }

    @Override
    public boolean accept(HandleValue[] values) {
        for (HandleValue value : values) {
            if (!this.matchesOne(value)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesOne(HandleValue value) {
        for (TypeAndValue typeAndValue : this.typeAndValueList) {
            String type = value.getTypeAsString();
            String data = value.getDataAsString();
            if (!typeAndValue.type.equals(type) || !typeAndValue.value.equals(data)) continue;
            return true;
        }
        return false;
    }

    public static class TypeAndValue {
        public String type;
        public String value;

        public TypeAndValue(String type, String value) {
            this.type = type;
            this.value = value;
        }
    }
}

