/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch.operations;

import java.util.ArrayList;
import java.util.List;
import net.handle.apps.batch.BatchUtil;
import net.handle.apps.batch.HandleRecordOperationInterface;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.SiteInfo;

public class HandlesUnderServiceFinderOperation
implements HandleRecordOperationInterface {
    public List<String> resultHandles;
    public String serviceHandle;

    public HandlesUnderServiceFinderOperation(String serviceHandle) {
        this.serviceHandle = serviceHandle;
        this.resultHandles = new ArrayList<String>();
    }

    @Override
    public void process(String handle, HandleValue[] values, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        if (this.containsSpecifiedServiceHandle(values)) {
            this.resultHandles.add(handle);
        }
    }

    private boolean containsSpecifiedServiceHandle(HandleValue[] values) {
        List<HandleValue> hsServValues = BatchUtil.getValuesOfType(values, "HS_SERV");
        for (HandleValue value : hsServValues) {
            String data = value.getDataAsString();
            String upCaseData = data.toUpperCase();
            if (!this.serviceHandle.equals(upCaseData)) continue;
            return true;
        }
        return false;
    }
}

