/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch.operations;

import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.handle.apps.batch.BatchUtil;
import net.handle.apps.batch.HandleRecordOperationInterface;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.hdllib.trust.HandleClaimsSet;
import net.handle.hdllib.trust.HandleSigner;
import net.handle.hdllib.trust.JsonWebSignature;
import net.handle.hdllib.trust.TrustException;

public class JoseSignHandleRecordOperation
implements HandleRecordOperationInterface {
    private PrivateKey issPrivateKey;
    private final ValueReference issIdentity;
    private final List<String> chain;
    private String baseUri;
    private String username;
    private String password;
    private String privateKeyId;
    private String privateKeyPassphrase;
    private boolean isRemote = false;

    public JoseSignHandleRecordOperation(PrivateKey issPrivateKey, ValueReference issIdentity, List<String> chain) {
        this.issPrivateKey = issPrivateKey;
        this.issIdentity = issIdentity;
        this.chain = chain;
    }

    public JoseSignHandleRecordOperation(ValueReference issIdentity, List<String> chain, String baseUri, String username, String password, String privateKeyId, String privateKeyPassphrase) {
        this.issIdentity = issIdentity;
        this.chain = chain;
        this.baseUri = baseUri;
        this.username = username;
        this.password = password;
        this.privateKeyId = privateKeyId;
        this.privateKeyPassphrase = privateKeyPassphrase;
        this.isRemote = true;
    }

    @Override
    public void process(String handle, HandleValue[] values, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        List<HandleValue> resultValues = new ArrayList<HandleValue>(Arrays.asList(values));
        resultValues = this.removeLegacySignatureValues(resultValues);
        resultValues = this.removeAllHsSignatureValues(resultValues);
        try {
            resultValues = this.addJoseSignatureOfValues(handle, resultValues);
        }
        catch (TrustException e) {
            throw new HandleException(10, handle, e);
        }
        AbstractResponse response = BatchUtil.updateEntireHandleRecord(handle, resultValues, resolver, authInfo, site);
        BatchUtil.throwIfNotSuccess(response);
    }

    private List<HandleValue> removeAllHsSignatureValues(List<HandleValue> values) {
        Iterator<HandleValue> it = values.iterator();
        while (it.hasNext()) {
            HandleValue value = it.next();
            String type = value.getTypeAsString();
            if (!"HS_SIGNATURE".equalsIgnoreCase(type)) continue;
            it.remove();
        }
        return values;
    }

    private List<HandleValue> removeLegacySignatureValues(List<HandleValue> values) {
        Iterator<HandleValue> it = values.iterator();
        while (it.hasNext()) {
            HandleValue value = it.next();
            String type = value.getTypeAsString();
            if (!"10320/sig.sig".equalsIgnoreCase(type) && !"10320/sig.digest".equalsIgnoreCase(type)) continue;
            it.remove();
        }
        return values;
    }

    private List<HandleValue> addJoseSignatureOfValues(String handle, List<HandleValue> values) throws TrustException {
        HandleSigner handleSigner = new HandleSigner();
        long now = System.currentTimeMillis() / 1000L - 600L;
        long oneYearInSeconds = 31622400L;
        long expiration = System.currentTimeMillis() / 1000L + oneYearInSeconds * 2L;
        List<HandleValue> valuesToSign = Util.filterOnlyPublicValues(values);
        HandleClaimsSet claims = handleSigner.createPayload(handle, valuesToSign, this.issIdentity, this.chain, now, expiration);
        JsonWebSignature jws = this.isRemote ? handleSigner.signClaimsRemotely(claims, this.baseUri, this.username, this.password, this.privateKeyId, this.privateKeyPassphrase) : handleSigner.signClaims(claims, this.issPrivateKey);
        HandleValue signatureHandleValue = new HandleValue(this.getNextUnusedIndex(400, values), "HS_SIGNATURE", jws.serialize());
        values.add(signatureHandleValue);
        return values;
    }

    public int getNextUnusedIndex(int firstIdx, List<HandleValue> values) {
        int nextIdx = firstIdx - 1;
        boolean duplicate = true;
        block0: while (duplicate) {
            ++nextIdx;
            duplicate = false;
            for (int i = values.size() - 1; i >= 0; --i) {
                HandleValue val = values.get(i);
                if (val == null || val.getIndex() != nextIdx) continue;
                duplicate = true;
                continue block0;
            }
        }
        return nextIdx;
    }
}

