/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.simple;

import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class LocalInfoConverter {
    public static Map<String, SiteInfo[]> convertFromJson(String json) {
        List list = (List)GsonUtility.getGson().fromJson(json, new TypeToken<List<LocalInfoEntry>>(){}.getType());
        HashMap<String, SiteInfo[]> res = new HashMap<String, SiteInfo[]>();
        for (LocalInfoEntry entry : list) {
            for (String na : entry.getNas()) {
                SiteInfo[] sites = (SiteInfo[])res.get(na);
                res.put(na, LocalInfoConverter.extendSites(sites, entry.getSite()));
            }
        }
        return res;
    }

    private static SiteInfo[] extendSites(SiteInfo[] sites, SiteInfo site) {
        if (sites == null || sites.length == 0) {
            return new SiteInfo[]{site};
        }
        SiteInfo[] newsites = new SiteInfo[sites.length + 1];
        System.arraycopy(sites, 0, newsites, 0, sites.length);
        newsites[sites.length] = site;
        return newsites;
    }

    public static String convertToJson(List<LocalInfoEntry> localInfo) {
        return GsonUtility.getNewGsonBuilder().disableHtmlEscaping().setPrettyPrinting().create().toJson(localInfo);
    }

    public static String convertToJson(Map<String, SiteInfo[]> localInfo) {
        LinkedHashMap<SiteInfo, ArrayList<String>> map = new LinkedHashMap<SiteInfo, ArrayList<String>>();
        for (Map.Entry<String, SiteInfo[]> entry : localInfo.entrySet()) {
            for (SiteInfo site : entry.getValue()) {
                ArrayList<String> nas = (ArrayList<String>)map.get(site);
                if (nas == null) {
                    nas = new ArrayList<String>();
                }
                nas.add(entry.getKey());
                map.put(site, nas);
            }
        }
        ArrayList<LocalInfoEntry> list = new ArrayList<LocalInfoEntry>();
        for (Map.Entry entry : map.entrySet()) {
            list.add(new LocalInfoEntry((List)entry.getValue(), (SiteInfo)entry.getKey()));
        }
        return LocalInfoConverter.convertToJson(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertToJson(byte[] bytes, OutputStream out) throws HandleException, IOException {
        try (ByteArrayInputStream input = new ByteArrayInputStream(bytes);){
            Map<String, SiteInfo[]> map = Encoder.decodeLocalSites(input);
            String json = LocalInfoConverter.convertToJson(map);
            out.write(json.getBytes("UTF-8"));
        }
    }

    public static void convertToBin(String json, OutputStream out) throws HandleException, IOException {
        List list = (List)GsonUtility.getGson().fromJson(json, new TypeToken<List<LocalInfoEntry>>(){}.getType());
        SiteInfo[] sites = new SiteInfo[list.size()];
        String[][] nas = new String[list.size()][];
        int i = 0;
        for (LocalInfoEntry entry : list) {
            sites[i] = entry.getSite();
            nas[i] = entry.getNas().toArray(new String[0]);
            ++i;
        }
        out.write(Encoder.encodeLocalSites(sites, nas));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        OutputStream out;
        String outputFilename = null;
        String inputFilename = null;
        boolean sawDash = false;
        boolean expectingOutput = false;
        boolean sawEndOfOptions = false;
        for (String arg : args) {
            if (!sawEndOfOptions && arg.length() >= 2 && arg.startsWith("-")) {
                if (arg.equals("--")) {
                    sawEndOfOptions = true;
                    continue;
                }
                if (arg.equals("-o") || arg.equals("-output") || arg.equals("--output")) {
                    if (outputFilename != null) {
                        System.err.println("Too many output files specified");
                        System.exit(1);
                        return;
                    }
                    expectingOutput = true;
                    continue;
                }
                if (arg.equals("-h") || arg.equals("-help") || arg.equals("--help")) {
                    System.err.println("arguments: [input-filename] [-o output-filename]");
                    System.err.println("local_info binary input will be converted to json");
                    System.err.println("json input will be converted to local_info binary");
                    System.exit(0);
                    return;
                }
                System.err.println("Unknown option " + arg);
                System.exit(1);
                return;
            }
            if (expectingOutput) {
                if (arg.equals("-")) continue;
                outputFilename = arg;
                continue;
            }
            if (sawDash || inputFilename != null) {
                System.err.println("Too many input files specified");
                System.exit(1);
                return;
            }
            if (arg.equals("-")) {
                sawDash = true;
                continue;
            }
            inputFilename = arg;
        }
        InputStream in = System.in;
        try {
            if (inputFilename != null) {
                in = new FileInputStream(new File(inputFilename));
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("File " + inputFilename + " not found");
            System.exit(1);
            return;
        }
        try {
            out = outputFilename != null ? new FileOutputStream(new File(outputFilename)) : System.out;
        }
        catch (FileNotFoundException e) {
            System.err.println("File " + outputFilename + " not writeable");
            System.exit(1);
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception arg) {
                    // empty catch block
                }
            }
            return;
        }
        byte[] buf = new byte[4096];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            int r;
            while ((r = in.read(buf)) > 0) {
                bout.write(buf, 0, r);
            }
        }
        catch (IOException e) {
            System.err.println("IOException reading input");
            System.exit(1);
            return;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        byte[] inputBytes = bout.toByteArray();
        try {
            if (Util.looksLikeBinary(inputBytes)) {
                LocalInfoConverter.convertToJson(inputBytes, out);
            } else {
                LocalInfoConverter.convertToBin(new String(inputBytes, "UTF-8"), out);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        catch (Exception e) {
            System.err.println(e.getClass().getSimpleName() + ": " + e.getMessage());
            System.exit(1);
            return;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static class LocalInfoEntry {
        private List<String> nas;
        private SiteInfo site;

        public LocalInfoEntry(List<String> nas, SiteInfo site) {
            this.nas = nas;
            this.site = site;
        }

        public List<String> getNas() {
            return this.nas;
        }

        public void setNas(List<String> nas) {
            this.nas = nas;
        }

        public SiteInfo getSite() {
            return this.site;
        }

        public void setSite(SiteInfo site) {
            this.site = site;
        }
    }
}

