/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.simple;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class SiteInfoConverter {
    public static String convertToJson(SiteInfo site) {
        return GsonUtility.getNewGsonBuilder().disableHtmlEscaping().setPrettyPrinting().create().toJson((Object)site);
    }

    public static SiteInfo convertToSiteInfo(String input) {
        return (SiteInfo)GsonUtility.getGson().fromJson(input, SiteInfo.class);
    }

    public static void convertToJson(byte[] input, OutputStream out) throws HandleException, IOException {
        SiteInfo site = new SiteInfo();
        Encoder.decodeSiteInfoRecord(input, 0, site);
        String json = SiteInfoConverter.convertToJson(site);
        out.write(json.getBytes("UTF-8"));
    }

    public static void convertToBin(String input, OutputStream out) throws IOException {
        SiteInfo site = SiteInfoConverter.convertToSiteInfo(input);
        out.write(Encoder.encodeSiteInfoRecord(site));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        OutputStream out;
        String outputFilename = null;
        String inputFilename = null;
        boolean sawDash = false;
        boolean expectingOutput = false;
        boolean sawEndOfOptions = false;
        for (String arg : args) {
            if (!sawEndOfOptions && arg.length() >= 2 && arg.startsWith("-")) {
                if (arg.equals("--")) {
                    sawEndOfOptions = true;
                    continue;
                }
                if (arg.equals("-o") || arg.equals("-output") || arg.equals("--output")) {
                    if (outputFilename != null) {
                        System.err.println("Too many output files specified");
                        System.exit(1);
                        return;
                    }
                    expectingOutput = true;
                    continue;
                }
                if (arg.equals("-h") || arg.equals("-help") || arg.equals("--help")) {
                    System.err.println("arguments: [input-filename] [-o output-filename]");
                    System.err.println("siteinfo.bin input will be converted to json");
                    System.err.println("json input will be converted to siteinfo.bin");
                    System.exit(0);
                    return;
                }
                System.err.println("Unknown option " + arg);
                System.exit(1);
                return;
            }
            if (expectingOutput) {
                if (arg.equals("-")) continue;
                outputFilename = arg;
                continue;
            }
            if (sawDash || inputFilename != null) {
                System.err.println("Too many input files specified");
                System.exit(1);
                return;
            }
            if (arg.equals("-")) {
                sawDash = true;
                continue;
            }
            inputFilename = arg;
        }
        InputStream in = System.in;
        try {
            if (inputFilename != null) {
                in = new FileInputStream(new File(inputFilename));
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("File " + inputFilename + " not found");
            System.exit(1);
            return;
        }
        try {
            out = outputFilename != null ? new FileOutputStream(new File(outputFilename)) : System.out;
        }
        catch (FileNotFoundException e) {
            System.err.println("File " + outputFilename + " not writeable");
            System.exit(1);
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception arg) {
                    // empty catch block
                }
            }
            return;
        }
        byte[] buf = new byte[4096];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            int r;
            while ((r = in.read(buf)) > 0) {
                bout.write(buf, 0, r);
            }
        }
        catch (IOException e) {
            System.err.println("IOException reading input");
            System.exit(1);
            return;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        byte[] inputBytes = bout.toByteArray();
        try {
            if (Util.looksLikeBinary(inputBytes)) {
                SiteInfoConverter.convertToJson(inputBytes, out);
            } else {
                SiteInfoConverter.convertToBin(new String(inputBytes, "UTF-8"), out);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        catch (Exception e) {
            System.err.println(e.getClass().getSimpleName() + ": " + e.getMessage());
            System.exit(1);
            return;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }
}

