/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import net.handle.hdllib.Util;

public class KeyGenerator {
    public static final void printUsage() {
        System.err.println("usage: hdl-keygen [-alg <algorithm>] [-keysize <numbits>] <privkeyfile> <pubkeyfile>");
    }

    public static void main(String[] argv) throws Exception {
        String algorithm = "RSA";
        int keySize = -1;
        File privKeyFile = null;
        File pubKeyFile = null;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].startsWith("-")) {
                if (argv[i].equalsIgnoreCase("-alg") && i + 1 < argv.length) {
                    algorithm = argv[++i];
                    continue;
                }
                if (argv[i].equalsIgnoreCase("-keysize") && i + 1 < argv.length) {
                    try {
                        keySize = Integer.parseInt(argv[++i]);
                    }
                    catch (Exception e) {
                        KeyGenerator.printUsage();
                        System.exit(1);
                    }
                    continue;
                }
                KeyGenerator.printUsage();
                System.exit(1);
                continue;
            }
            if (privKeyFile == null) {
                privKeyFile = new File(argv[i]);
                continue;
            }
            if (pubKeyFile == null) {
                pubKeyFile = new File(argv[i]);
                continue;
            }
            KeyGenerator.printUsage();
            System.exit(1);
        }
        if (keySize <= 0) {
            keySize = "RSA".equals(algorithm) ? 2048 : 1024;
        }
        if (privKeyFile == null || pubKeyFile == null) {
            KeyGenerator.printUsage();
            System.exit(1);
        }
        PrintStream out = System.out;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        boolean encrypt = true;
        out.println("\nThe private key that is about to be generated should be stored");
        out.println("in an encrypted form on your computer.  Encryption of the");
        out.println("private key requires that you choose a secret passphrase that");
        out.println("will need to be entered whenever the server is started.");
        out.println("Note: Please take all precautions to make sure that only authorized ");
        out.println("users can read your private key.");
        while (true) {
            out.print("\nWould you like to encrypt your private key? (y/n) [y] ");
            out.flush();
            String line = in.readLine().trim().toUpperCase();
            if (line.length() <= 0) {
                encrypt = true;
                break;
            }
            if (line.equals("Y")) {
                encrypt = true;
                break;
            }
            if (line.equals("N")) {
                encrypt = false;
                break;
            }
            System.out.println("Invalid response, try again.");
        }
        byte[] secKey = null;
        if (encrypt) {
            byte[] secKey2;
            while (!Util.equals(secKey = Util.getPassphrase("Please enter the private key passphrase:"), secKey2 = Util.getPassphrase("Please re-enter the private key passphrase: "))) {
                System.err.println("Passphrases do not match!  Try again.\n");
            }
        }
        out.println("Generating keys; algorithm=" + algorithm + "; keysize=" + keySize);
        KeyGenerator.generateKeys(algorithm, keySize, secKey, privKeyFile, pubKeyFile);
    }

    public static final void generateKeys(String algorithm, int keySize, byte[] secKey, File privKeyFile, File pubKeyFile) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(algorithm);
        kpg.initialize(keySize);
        KeyPair keys = kpg.generateKeyPair();
        byte[] keyBytes = Util.getBytesFromPrivateKey(keys.getPrivate());
        byte[] encKeyBytes = null;
        if (secKey != null) {
            int i;
            encKeyBytes = Util.encrypt(keyBytes, secKey, 4);
            for (i = 0; i < keyBytes.length; ++i) {
                keyBytes[i] = 0;
            }
            for (i = 0; i < secKey.length; ++i) {
                secKey[i] = 0;
            }
        } else {
            encKeyBytes = Util.encrypt(keyBytes, secKey, 1);
        }
        FileOutputStream fout = new FileOutputStream(privKeyFile);
        fout.write(encKeyBytes);
        fout.close();
        fout = new FileOutputStream(pubKeyFile);
        fout.write(Util.getBytesFromPublicKey(keys.getPublic()));
        fout.close();
    }
}

