/*
 * Decompiled with CFR 0.152.
 */
package net.handle.dnslib;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.handle.dnslib.Message;
import net.handle.dnslib.Question;
import net.handle.util.LRUCacheTable;

public class Cache {
    public static final int MAXIMUM_TTL = 86400;
    private final QueryResolver cacheRunner;
    private final ExecutorService prefetcher;
    private final LRUCacheTable<Key, Value> lrutable;

    public Cache(QueryResolver cacheRunner, int numPrefetcherThreads, int cacheSize) {
        this.cacheRunner = cacheRunner;
        this.prefetcher = new ThreadPoolExecutor(numPrefetcherThreads, numPrefetcherThreads, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
        this.lrutable = new LRUCacheTable(cacheSize);
    }

    public void shutdown() {
        this.prefetcher.shutdownNow();
    }

    public void put(Message query, Message response) {
        if (response.getTTL() <= 0) {
            return;
        }
        try {
            response.getDatagram(65535);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.lrutable.put(new Key(query), new Value(response));
    }

    public Message get(Message query) {
        Key key = new Key(query);
        Value response = this.lrutable.get(key);
        if (response == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        int ttl = Math.min(response.response.getTTL(), 86400);
        long expires = response.timestamp + 1000L * (long)ttl;
        if (expires <= now) {
            this.lrutable.remove(key);
            return null;
        }
        if (expires - response.timestamp < 2L * (now - response.timestamp)) {
            try {
                this.prefetcher.execute(() -> this.cacheRunner.resolve(query));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        Message res = Message.copy(response.response);
        res.id = query.id;
        res.recursionDesired = query.recursionDesired;
        return res;
    }

    public static interface QueryResolver {
        public void resolve(Message var1);
    }

    private static class Value {
        final Message response;
        final long timestamp;

        public Value(Message response) {
            this.response = response;
            this.timestamp = System.currentTimeMillis();
        }
    }

    private static class Key {
        final Question question;
        final int ednsVersion;

        public Key(Message query) {
            if (query == null || query.getQuestion() == null) {
                throw new NullPointerException();
            }
            this.question = query.getQuestion();
            this.ednsVersion = query.getEDNSVersion();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            return this.question.equals(key.question) && this.ednsVersion == key.ednsVersion;
        }

        public int hashCode() {
            return 31 * this.question.hashCode() + this.ednsVersion;
        }
    }
}

