/*
 * Decompiled with CFR 0.152.
 */
package net.handle.dnslib;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import net.handle.dnslib.DomainName;
import net.handle.dnslib.ParseException;

public class Question {
    private final DomainName name;
    private final int type;
    private final int klass;

    public Question(DomainName name, int type, int klass) {
        this.name = name;
        this.type = type;
        this.klass = klass;
    }

    public DomainName getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getKlass() {
        return this.klass;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Question)) {
            return false;
        }
        Question other = (Question)obj;
        return this.name.equals(other.name) && this.type == other.type && this.klass == other.klass;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.type;
        result = 31 * result + this.klass;
        return result;
    }

    public static Question parseWire(byte[] wire, int[] offsetArr) throws ParseException {
        DomainName owner = DomainName.parseWire(wire, offsetArr);
        int offset = offsetArr[0];
        if (offset + 4 > wire.length) {
            throw new ParseException("IndexOutOfBounds parsing question");
        }
        int type = (wire[offset++] & 0xFF) << 8 | wire[offset++] & 0xFF;
        int klass = (wire[offset++] & 0xFF) << 8 | wire[offset++] & 0xFF;
        offsetArr[0] = offset;
        return new Question(owner, type, klass);
    }

    public int appendToWireWithCompression(OutputStream wire, int offset, Map<DomainName, Integer> compressionTable) throws IOException {
        offset = this.name.appendToWireWithCompression(wire, offset, compressionTable);
        wire.write(this.type >> 8 & 0xFF);
        wire.write(this.type & 0xFF);
        wire.write(this.klass >> 8 & 0xFF);
        wire.write(this.klass & 0xFF);
        return offset + 4;
    }

    public boolean isAnswerFor(Question question) {
        if (question == null) {
            return false;
        }
        if (this.getKlass() == question.getKlass() && this.getName().equals(question.getName())) {
            if (question.getType() == 255) {
                return true;
            }
            if (question.getType() == 254) {
                return this.type == 3 || this.type == 4;
            }
            if (question.getType() == 253) {
                return this.type == 7 || this.type == 8 || this.type == 9;
            }
            return this.getType() == question.getType();
        }
        return false;
    }
}

