/*
 * Decompiled with CFR 0.152.
 */
package net.handle.dnslib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.handle.dnslib.Question;
import net.handle.dnslib.ResourceRecord;

public class RRSet
implements Iterable<ResourceRecord> {
    private ArrayList<ResourceRecord> rrs = new ArrayList();

    public RRSet(ResourceRecord rr) {
        this.rrs.add(rr);
    }

    protected RRSet(RRSet rrSet) {
        this.rrs = rrSet.rrs;
    }

    public void add(ResourceRecord rr) {
        this.rrs.add(rr);
    }

    public Question getKey() {
        return this.rrs.get(0).getKey();
    }

    public int getType() {
        return this.rrs.get(0).getType();
    }

    public int getTTL() {
        int min = Integer.MAX_VALUE;
        for (ResourceRecord rr : this.rrs) {
            if (rr.getTTL() <= 0) {
                min = 0;
                continue;
            }
            if (rr.getTTL() >= min) continue;
            min = rr.getTTL();
        }
        return min;
    }

    public void fixTTL() {
        int ttl = this.getTTL();
        for (ResourceRecord rr : this.rrs) {
            rr.setTTL(ttl);
        }
    }

    @Override
    public Iterator<ResourceRecord> iterator() {
        return this.rrs.iterator();
    }

    public int size() {
        return this.rrs.size();
    }

    public void shuffle() {
        Collections.shuffle(this.rrs);
    }
}

