/*
 * Decompiled with CFR 0.152.
 */
package net.handle.dnslib;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.handle.dnslib.Cache;
import net.handle.dnslib.Message;
import net.handle.dnslib.NameResolver;
import net.handle.dnslib.ParseException;
import net.handle.dnslib.Question;
import net.handle.dnslib.ResourceRecord;

public class StubResolver
implements NameResolver {
    private final List<InetAddress> recursiveResolvers;
    private final boolean useLargeEDNS;
    private Cache cache;
    private static final Random RANDOM = new Random();

    public StubResolver(List<InetAddress> recursiveResolvers, boolean useLargeEDNS) {
        this.recursiveResolvers = recursiveResolvers;
        this.useLargeEDNS = useLargeEDNS;
    }

    @Override
    public void setCache(int prefetcherThreads, int size) {
        if (size <= 0) {
            return;
        }
        this.cache = new Cache(query -> this.realRespondToQuery(query), prefetcherThreads, size);
    }

    @Override
    public Message respondToQuery(Message query) {
        Message response;
        if (this.cache != null && (response = this.cache.get(query)) != null) {
            return response;
        }
        return this.realRespondToQuery(query);
    }

    Message realRespondToQuery(Message incomingQuery) {
        Message initialResponse = Message.initialResponse(incomingQuery, false, false);
        if (initialResponse == null || initialResponse.getExtendedResponseCode() != 0) {
            return initialResponse;
        }
        ArrayList<InetAddress> resolversCopy = new ArrayList<InetAddress>(this.recursiveResolvers.size());
        resolversCopy.addAll(this.recursiveResolvers);
        Collections.shuffle(resolversCopy);
        for (InetAddress serverAddress : resolversCopy) {
            Message response = this.udpResponse(incomingQuery.getQuestion(), serverAddress);
            if (response == null) continue;
            if (response.truncated) {
                response = this.tcpResponse(incomingQuery.getQuestion(), serverAddress);
            }
            if (response == null) continue;
            response.id = incomingQuery.id;
            if (incomingQuery.ednsOptRecord != null) {
                ResourceRecord resourceRecord = response.ednsOptRecord = this.useLargeEDNS ? Message.LARGE_EDNS : Message.SMALL_EDNS;
            }
            if (this.cache != null) {
                this.cache.put(incomingQuery, response);
            }
            return response;
        }
        Message response = Message.initialResponse(incomingQuery, true, this.useLargeEDNS);
        response.setResponseCode((byte)2);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message udpResponse(Question question, InetAddress serverAddress) {
        DatagramSocket sock = null;
        try {
            while (sock == null) {
                int port = RANDOM.nextInt(62311) + 1025;
                int count = 0;
                try {
                    sock = new DatagramSocket(port);
                }
                catch (BindException e) {
                    if (++count <= 20) continue;
                    System.err.println("Unable to find random source port.");
                    sock = new DatagramSocket();
                }
            }
            sock.setSoTimeout(10000);
            Message query = new Message(question, true, false);
            byte[] queryBytes = query.getDatagram(512);
            DatagramPacket packet = new DatagramPacket(queryBytes, queryBytes.length, serverAddress, 53);
            sock.send(packet);
            packet = new DatagramPacket(new byte[512], 512);
            try {
                sock.receive(packet);
            }
            catch (Exception e) {
                Message message = null;
                if (sock == null) return message;
                try {
                    sock.close();
                    return message;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return message;
            }
            try {
                sock.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!serverAddress.equals(packet.getAddress())) {
                Message e = null;
                return e;
            }
            Message response = new Message();
            try {
                response.parseWire(packet.getData());
            }
            catch (ParseException e) {
                Message message = null;
                if (sock == null) return message;
                try {
                    sock.close();
                    return message;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return message;
            }
            if (response.id != query.id) {
                Message message = null;
                return message;
            }
            if (!query.getQuestion().equals(response.getQuestion())) {
                Message message = null;
                return message;
            }
            Message message = response;
            return message;
        }
        catch (IOException e) {
            e.printStackTrace();
            Message message = null;
            return message;
        }
        finally {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message tcpResponse(Question question, InetAddress serverAddress) {
        Socket tcpSock = new Socket();
        try {
            Message message;
            byte[] responseBytes;
            while (true) {
                int port = RANDOM.nextInt(62311) + 1025;
                int count = 0;
                try {
                    tcpSock.bind(new InetSocketAddress(port));
                }
                catch (BindException e) {
                    if (++count <= 20) continue;
                    System.err.println("Unable to find random source port.");
                    tcpSock.bind(null);
                }
                break;
            }
            tcpSock.setSoTimeout(20000);
            tcpSock.setSoLinger(false, 0);
            tcpSock.connect(new InetSocketAddress(serverAddress, 53), 20000);
            Message query = new Message(question, true, false);
            try (InputStream in = tcpSock.getInputStream();
                 OutputStream out = tcpSock.getOutputStream();){
                int n;
                byte[] buf = query.getDatagram(65535);
                out.write(buf.length >> 8 & 0xFF);
                out.write(buf.length & 0xFF);
                out.write(buf);
                int firstByte = in.read();
                int secondByte = in.read();
                if (firstByte < 0 || secondByte < 0) {
                    Message message2 = null;
                    return message2;
                }
                int len = (firstByte & 0xFF) << 8 | secondByte & 0xFF;
                responseBytes = new byte[len];
                int r = 0;
                for (n = 0; n < len && (r = in.read(responseBytes, n, len - n)) > 0; n += r) {
                }
                if (n < len) {
                    Message message3 = null;
                    return message3;
                }
                try {
                    tcpSock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Message response = new Message();
            try {
                response.parseWire(responseBytes);
            }
            catch (ParseException e) {
                Message message4 = null;
                try {
                    tcpSock.close();
                    return message4;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return message4;
            }
            if (response.id != query.id) {
                message = null;
                return message;
            }
            if (!query.getQuestion().equals(response.getQuestion())) {
                message = null;
                return message;
            }
            message = response;
            return message;
        }
        catch (IOException e) {
            e.printStackTrace();
            Message message = null;
            return message;
        }
        finally {
            try {
                tcpSock.close();
            }
            catch (Exception exception) {}
        }
    }
}

