/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public abstract class AbstractMessage
implements Cloneable {
    public static final int OC_RESERVED = 0;
    public static final int OC_RESOLUTION = 1;
    public static final int OC_GET_SITE_INFO = 2;
    public static final int OC_CREATE_HANDLE = 100;
    public static final int OC_DELETE_HANDLE = 101;
    public static final int OC_ADD_VALUE = 102;
    public static final int OC_REMOVE_VALUE = 103;
    public static final int OC_MODIFY_VALUE = 104;
    public static final int OC_LIST_HANDLES = 105;
    public static final int OC_RESPONSE_TO_CHALLENGE = 200;
    public static final int OC_VERIFY_CHALLENGE = 201;
    public static final int OC_HOME_NA = 300;
    public static final int OC_UNHOME_NA = 301;
    public static final int OC_LIST_HOMED_NAS = 302;
    public static final int OC_SESSION_SETUP = 400;
    public static final int OC_SESSION_TERMINATE = 401;
    public static final int OC_SESSION_EXCHANGEKEY = 402;
    public static final int OC_GET_NEXT_TXN_ID = 1000;
    public static final int OC_RETRIEVE_TXN_LOG = 1001;
    public static final int OC_DUMP_HANDLES = 1002;
    public static final int OC_BACKUP_SERVER = 1003;
    public static final int RC_RESERVED = 0;
    public static final int RC_SUCCESS = 1;
    public static final int RC_ERROR = 2;
    public static final int RC_SERVER_TOO_BUSY = 3;
    public static final int RC_PROTOCOL_ERROR = 4;
    public static final int RC_OPERATION_NOT_SUPPORTED = 5;
    public static final int RC_RECURSION_COUNT_TOO_HIGH = 6;
    public static final int RC_SERVER_BACKUP = 7;
    public static final int RC_HANDLE_NOT_FOUND = 100;
    public static final int RC_HANDLE_ALREADY_EXISTS = 101;
    public static final int RC_INVALID_HANDLE = 102;
    public static final int RC_VALUES_NOT_FOUND = 200;
    public static final int RC_VALUE_ALREADY_EXISTS = 201;
    public static final int RC_INVALID_VALUE = 202;
    public static final int RC_OUT_OF_DATE_SITE_INFO = 300;
    public static final int RC_SERVER_NOT_RESP = 301;
    public static final int RC_SERVICE_REFERRAL = 302;
    public static final int RC_PREFIX_REFERRAL = 303;
    public static final int RC_INVALID_ADMIN = 400;
    public static final int RC_INSUFFICIENT_PERMISSIONS = 401;
    public static final int RC_AUTHENTICATION_NEEDED = 402;
    public static final int RC_AUTHENTICATION_FAILED = 403;
    public static final int RC_INVALID_CREDENTIAL = 404;
    public static final int RC_AUTHEN_TIMEOUT = 405;
    public static final int RC_AUTHEN_ERROR = 406;
    public static final int RC_SESSION_TIMEOUT = 500;
    public static final int RC_SESSION_FAILED = 501;
    public static final int RC_INVALID_SESSION_KEY = 502;
    public static final int RC_NEED_RSAKEY_FOR_SESSIONEXCHANGE = 503;
    public static final int RC_INVALID_SESSIONSETUP_REQUEST = 504;
    public static final int RC_SESSION_MESSAGE_REJECTED = 505;
    public int requestId = -1;
    public int sessionId = 0;
    public byte majorProtocolVersion = (byte)2;
    public byte minorProtocolVersion = (byte)3;
    public byte suggestMajorProtocolVersion = (byte)2;
    public byte suggestMinorProtocolVersion = (byte)11;
    public int opCode;
    public int responseCode = 0;
    public int siteInfoSerial = -1;
    public int expiration;
    public short recursionCount = 0;
    public boolean certify = false;
    public boolean cacheCertify = true;
    public boolean authoritative = false;
    public boolean encrypt = false;
    public boolean ignoreRestrictedValues = true;
    public boolean returnRequestDigest = false;
    public boolean recursive = true;
    public boolean continuous = false;
    public boolean keepAlive = false;
    public boolean overwriteWhenExists = false;
    public boolean mintNewSuffix = false;
    public boolean doNotRefer = false;
    public byte[] signerHdl = null;
    public int signerHdlIdx = 0;
    public byte[] messageBody = null;
    public byte[] signature = null;
    public byte[] encodedMessage = null;
    public byte[] requestDigest = null;
    public byte rdHashType = (byte)2;
    public int sessionCounter = 0;

    public AbstractMessage() {
        this.expiration = (int)(System.currentTimeMillis() / 1000L) + 43200;
    }

    public AbstractMessage(int opCode) {
        this.opCode = opCode;
        this.expiration = (int)(System.currentTimeMillis() / 1000L) + 43200;
    }

    protected AbstractMessage clone() {
        try {
            return (AbstractMessage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void setSupportedProtocolVersion(AbstractMessage message) {
        this.majorProtocolVersion = message.suggestMajorProtocolVersion;
        this.minorProtocolVersion = message.suggestMinorProtocolVersion;
        this.setSupportedProtocolVersion();
    }

    public void setSupportedProtocolVersion(SiteInfo site) {
        this.majorProtocolVersion = site.majorProtocolVersion;
        this.minorProtocolVersion = site.minorProtocolVersion;
        this.setSupportedProtocolVersion();
    }

    public void setSupportedProtocolVersion() {
        if (this.hasEqualOrGreaterVersion(2, 11)) {
            this.majorProtocolVersion = (byte)2;
            this.minorProtocolVersion = (byte)11;
        }
    }

    public boolean hasEqualOrGreaterVersion(int majorVersion, int minorVersion) {
        if (this.majorProtocolVersion == 5) {
            return majorVersion == 5 && this.minorProtocolVersion >= minorVersion;
        }
        if (majorVersion == 5) {
            return true;
        }
        if (this.majorProtocolVersion > majorVersion) {
            return true;
        }
        if (this.majorProtocolVersion < majorVersion) {
            return false;
        }
        return this.minorProtocolVersion >= minorVersion;
    }

    public static boolean hasEqualOrGreaterVersion(int majorProtocolVersion, int minorProtocolVersion, int majorVersion, int minorVersion) {
        if (majorProtocolVersion == 5) {
            return majorVersion == 5 && minorProtocolVersion >= minorVersion;
        }
        if (majorVersion == 5) {
            return true;
        }
        if (majorProtocolVersion > majorVersion) {
            return true;
        }
        if (majorProtocolVersion < majorVersion) {
            return false;
        }
        return minorProtocolVersion >= minorVersion;
    }

    public void takeValuesFrom(AbstractMessage msg) {
        this.certify = msg.certify;
        this.cacheCertify = msg.cacheCertify;
        this.authoritative = msg.authoritative;
        this.encrypt = msg.encrypt;
        this.ignoreRestrictedValues = msg.ignoreRestrictedValues;
        this.doNotRefer = msg.doNotRefer;
        this.recursionCount = msg.recursionCount;
        this.returnRequestDigest = this.returnRequestDigest || msg.returnRequestDigest;
        this.majorProtocolVersion = msg.majorProtocolVersion;
        this.minorProtocolVersion = msg.minorProtocolVersion;
        this.suggestMajorProtocolVersion = msg.suggestMajorProtocolVersion;
        this.suggestMinorProtocolVersion = msg.suggestMinorProtocolVersion;
    }

    public final void signMessage(byte[] secretKey) throws HandleException {
        byte[] signatureBytes;
        boolean newVersion = this.hasEqualOrGreaterVersion(2, 7);
        boolean brokenVersion = !newVersion && this.hasEqualOrGreaterVersion(2, 5);
        byte[] messageHeaderAndBody = this.getEncodedMessageBody();
        byte[] sigType = Common.CREDENTIAL_TYPE_MAC;
        byte[] sigHashType = this.hasEqualOrGreaterVersion(2, 7) ? Common.HASH_ALG_HMAC_SHA256 : (this.hasEqualOrGreaterVersion(2, 6) ? Common.HASH_ALG_SHA1 : new byte[]{2});
        if (brokenVersion) {
            signatureBytes = this.brokenTwoFiveTwoSixSignature(sigHashType, messageHeaderAndBody, secretKey);
        } else {
            boolean hasSuggest;
            int tobeMACedLength = messageHeaderAndBody.length;
            if (newVersion) {
                tobeMACedLength += 14;
            }
            if (hasSuggest = this.hasEqualOrGreaterVersion(2, 8)) {
                tobeMACedLength += 2;
            }
            byte[] tobeMACed = new byte[tobeMACedLength];
            int offset = 0;
            if (newVersion) {
                tobeMACed[offset++] = this.majorProtocolVersion;
                tobeMACed[offset++] = this.minorProtocolVersion;
                if (hasSuggest) {
                    tobeMACed[offset++] = this.suggestMajorProtocolVersion;
                    tobeMACed[offset++] = this.suggestMinorProtocolVersion;
                }
                offset += Encoder.writeInt(tobeMACed, offset, this.sessionId);
                offset += Encoder.writeInt(tobeMACed, offset, this.requestId);
                offset += Encoder.writeInt(tobeMACed, offset, this.sessionCounter);
            }
            System.arraycopy(messageHeaderAndBody, 0, tobeMACed, offset, messageHeaderAndBody.length);
            signatureBytes = Util.doMac(sigHashType, tobeMACed, secretKey);
        }
        int offset = 0;
        int signatureLength = 8 + sigType.length + 4 + 8 + 4 + signatureBytes.length + 4 + sigHashType.length;
        this.signature = new byte[signatureLength];
        this.signature[offset++] = 0;
        this.signature[offset++] = 0;
        offset += Encoder.writeInt2(this.signature, offset, 0);
        offset += Encoder.writeByteArray(this.signature, offset, null);
        offset += Encoder.writeInt(this.signature, offset, this.sessionCounter);
        offset += Encoder.writeByteArray(this.signature, offset, sigType);
        offset += Encoder.writeInt(this.signature, offset, sigHashType.length + 4 + signatureBytes.length + 4);
        offset += Encoder.writeByteArray(this.signature, offset, sigHashType);
        offset += Encoder.writeByteArray(this.signature, offset, signatureBytes);
        this.encodedMessage = null;
    }

    private byte[] brokenTwoFiveTwoSixSignature(byte[] sigHashType, byte[] messageHeaderAndBody, byte[] secretKey) throws HandleException {
        int tobeMACedLength = 2 * secretKey.length + messageHeaderAndBody.length;
        byte[] tobeMACed = new byte[tobeMACedLength += 14];
        System.arraycopy(secretKey, 0, tobeMACed, 0, secretKey.length);
        int offset = secretKey.length;
        tobeMACed[offset++] = this.majorProtocolVersion;
        tobeMACed[offset++] = this.minorProtocolVersion;
        offset = Encoder.writeInt(tobeMACed, offset, this.sessionId);
        offset = Encoder.writeInt(tobeMACed, offset, this.requestId);
        offset = Encoder.writeInt(tobeMACed, offset, this.sessionCounter);
        System.arraycopy(messageHeaderAndBody, 0, tobeMACed, offset, messageHeaderAndBody.length);
        System.arraycopy(secretKey, 0, tobeMACed, offset + messageHeaderAndBody.length, secretKey.length);
        return Util.doDigest(sigHashType, (byte[][])new byte[][]{tobeMACed});
    }

    public final void signMessage(Signature signer) throws HandleException, SignatureException {
        if (this.hasEqualOrGreaterVersion(2, 6)) {
            boolean newVersion = this.hasEqualOrGreaterVersion(2, 7);
            boolean hasSuggest = this.hasEqualOrGreaterVersion(2, 8);
            int versionBytes = hasSuggest ? 4 : 2;
            byte[] toBeSigned = new byte[versionBytes + 12];
            int offset = 0;
            toBeSigned[offset++] = this.majorProtocolVersion;
            toBeSigned[offset++] = this.minorProtocolVersion;
            if (hasSuggest) {
                toBeSigned[offset++] = this.suggestMajorProtocolVersion;
                toBeSigned[offset++] = this.suggestMinorProtocolVersion;
            }
            if (newVersion) {
                offset += Encoder.writeInt(toBeSigned, offset, this.sessionId);
                offset += Encoder.writeInt(toBeSigned, offset, this.requestId);
                offset += Encoder.writeInt(toBeSigned, offset, this.sessionCounter);
            } else {
                offset = Encoder.writeInt(toBeSigned, offset, this.sessionId);
                offset = Encoder.writeInt(toBeSigned, offset, this.requestId);
                offset = Encoder.writeInt(toBeSigned, offset, this.sessionCounter);
            }
            signer.update(toBeSigned);
        }
        signer.update(this.getEncodedMessageBody());
        byte[] sigType = Common.CREDENTIAL_TYPE_SIGNED;
        byte[] sigHashType = Util.getHashAlgIdFromSigId(signer.getAlgorithm());
        byte[] signatureBytes = signer.sign();
        int offset = 0;
        this.signature = new byte[8 + sigType.length + 4 + 8 + 4 + signatureBytes.length + 4 + sigHashType.length];
        this.signature[offset++] = 0;
        this.signature[offset++] = 0;
        offset += Encoder.writeInt2(this.signature, offset, 0);
        offset += Encoder.writeByteArray(this.signature, offset, null);
        offset += Encoder.writeInt(this.signature, offset, this.sessionCounter);
        offset += Encoder.writeByteArray(this.signature, offset, sigType);
        offset += Encoder.writeInt(this.signature, offset, sigHashType.length + 4 + signatureBytes.length + 4);
        offset += Encoder.writeByteArray(this.signature, offset, sigHashType);
        offset += Encoder.writeByteArray(this.signature, offset, signatureBytes);
        this.encodedMessage = null;
    }

    public boolean signatureIsMac() throws HandleException {
        if (this.signature == null || this.signature.length <= 0) {
            return false;
        }
        int offset = 0;
        byte sigVersion = this.signature[offset++];
        byte reserved = this.signature[offset++];
        int flags = Encoder.readInt2(this.signature, offset);
        byte[] emptyByte = Encoder.readByteArray(this.signature, offset += 2);
        int sessionCounterNotSavedHereButDuringVerification = Encoder.readInt(this.signature, offset += 4 + emptyByte.length);
        byte[] sigType = Encoder.readByteArray(this.signature, offset += 4);
        offset += 4 + sigType.length;
        return Util.equals(sigType, Common.CREDENTIAL_TYPE_MAC);
    }

    public final boolean verifyMessage(byte[] secretKey) throws Exception {
        byte[] verifyDigest;
        if (this.signature == null || this.signature.length <= 0) {
            return false;
        }
        int offset = 0;
        byte sigVersion = this.signature[offset++];
        byte reserved = this.signature[offset++];
        int flags = Encoder.readInt2(this.signature, offset);
        byte[] emptyByte = Encoder.readByteArray(this.signature, offset += 2);
        this.sessionCounter = Encoder.readInt(this.signature, offset += 4 + emptyByte.length);
        byte[] sigType = Encoder.readByteArray(this.signature, offset += 4);
        offset += 4 + sigType.length;
        if (!Util.equals(sigType, Common.CREDENTIAL_TYPE_MAC)) {
            throw new HandleException(16, "Unknown signature type: " + Util.decodeString(sigType));
        }
        int sigSectionLength = Encoder.readInt(this.signature, offset);
        byte[] hashAlgBytes = Encoder.readByteArray(this.signature, offset += 4);
        byte[] origDigestBytes = Encoder.readByteArray(this.signature, offset += 4 + hashAlgBytes.length);
        byte[] messageHeaderAndBody = this.getEncodedMessageBody();
        if (this.hasEqualOrGreaterVersion(2, 5) && !this.hasEqualOrGreaterVersion(2, 7)) {
            verifyDigest = this.brokenTwoFiveTwoSixSignature(hashAlgBytes, messageHeaderAndBody, secretKey);
        } else {
            byte[] tobeMACed;
            if (!this.hasEqualOrGreaterVersion(2, 5)) {
                tobeMACed = new byte[messageHeaderAndBody.length];
                System.arraycopy(messageHeaderAndBody, 0, tobeMACed, 0, messageHeaderAndBody.length);
            } else {
                boolean hasSuggest = this.hasEqualOrGreaterVersion(2, 8);
                int versionBytes = hasSuggest ? 4 : 2;
                tobeMACed = new byte[messageHeaderAndBody.length + versionBytes + 12];
                offset = 0;
                tobeMACed[offset++] = this.majorProtocolVersion;
                tobeMACed[offset++] = this.minorProtocolVersion;
                if (hasSuggest) {
                    tobeMACed[offset++] = this.suggestMajorProtocolVersion;
                    tobeMACed[offset++] = this.suggestMinorProtocolVersion;
                }
                offset += Encoder.writeInt(tobeMACed, offset, this.sessionId);
                offset += Encoder.writeInt(tobeMACed, offset, this.requestId);
                offset += Encoder.writeInt(tobeMACed, offset, this.sessionCounter);
                System.arraycopy(messageHeaderAndBody, 0, tobeMACed, offset, messageHeaderAndBody.length);
            }
            verifyDigest = Util.doMac(hashAlgBytes, tobeMACed, secretKey);
        }
        return Util.equals(origDigestBytes, verifyDigest);
    }

    public final boolean verifyMessage(PublicKey pubKey) throws Exception {
        if (this.signature == null || this.signature.length <= 0) {
            return false;
        }
        int offset = 0;
        byte sigVersion = this.signature[offset++];
        byte reserved = this.signature[offset++];
        int flags = Encoder.readInt2(this.signature, offset);
        byte[] disused = Encoder.readByteArray(this.signature, offset += 2);
        this.sessionCounter = Encoder.readInt(this.signature, offset += 4 + disused.length);
        byte[] sigType = Encoder.readByteArray(this.signature, offset += 4);
        offset += 4 + sigType.length;
        if (!Util.equals(sigType, Common.CREDENTIAL_TYPE_SIGNED) && !Util.equals(sigType, Common.CREDENTIAL_TYPE_OLDSIGNED)) {
            throw new HandleException(16, "Unknown signature type: " + Util.decodeString(sigType));
        }
        int sigSectionLength = Encoder.readInt(this.signature, offset);
        byte[] hashAlgBytes = Encoder.readByteArray(this.signature, offset += 4);
        byte[] sigBytes = Encoder.readByteArray(this.signature, offset += 4 + hashAlgBytes.length);
        Signature sig = Signature.getInstance(Util.getSigIdFromHashAlgId(hashAlgBytes, pubKey.getAlgorithm()));
        sig.initVerify(pubKey);
        if (this.hasEqualOrGreaterVersion(2, 6)) {
            boolean newVersion = this.hasEqualOrGreaterVersion(2, 7);
            boolean hasSuggest = this.hasEqualOrGreaterVersion(2, 8);
            int versionBytes = hasSuggest ? 4 : 2;
            byte[] toBeSigned = new byte[versionBytes + 12];
            offset = 0;
            toBeSigned[offset++] = this.majorProtocolVersion;
            toBeSigned[offset++] = this.minorProtocolVersion;
            if (hasSuggest) {
                toBeSigned[offset++] = this.suggestMajorProtocolVersion;
                toBeSigned[offset++] = this.suggestMinorProtocolVersion;
            }
            if (newVersion) {
                offset += Encoder.writeInt(toBeSigned, offset, this.sessionId);
                offset += Encoder.writeInt(toBeSigned, offset, this.requestId);
                offset += Encoder.writeInt(toBeSigned, offset, this.sessionCounter);
            } else {
                offset = Encoder.writeInt(toBeSigned, offset, this.sessionId);
                offset = Encoder.writeInt(toBeSigned, offset, this.requestId);
                offset = Encoder.writeInt(toBeSigned, offset, this.sessionCounter);
            }
            sig.update(toBeSigned);
        }
        sig.update(this.getEncodedMessageBody());
        return sig.verify(sigBytes);
    }

    public boolean shouldEncrypt() {
        return false;
    }

    public void clearBuffers() {
        this.encodedMessage = null;
        this.signature = null;
        this.messageBody = null;
    }

    public final byte[] getEncodedMessageBody() throws HandleException {
        if (this.messageBody != null) {
            return this.messageBody;
        }
        this.messageBody = Encoder.encodeMessage(this);
        return this.messageBody;
    }

    public final byte[] getEncodedMessage() throws HandleException {
        if (this.encodedMessage != null) {
            return this.encodedMessage;
        }
        this.getEncodedMessageBody();
        this.encodedMessage = new byte[this.messageBody.length + 4 + (this.signature == null ? 0 : this.signature.length)];
        System.arraycopy(this.messageBody, 0, this.encodedMessage, 0, this.messageBody.length);
        if (this.signature == null) {
            Encoder.writeInt(this.encodedMessage, this.messageBody.length, 0);
        } else {
            Encoder.writeInt(this.encodedMessage, this.messageBody.length, this.signature.length);
            System.arraycopy(this.signature, 0, this.encodedMessage, this.messageBody.length + 4, this.signature.length);
        }
        return this.encodedMessage;
    }

    public String toString() {
        return "version=" + this.majorProtocolVersion + '.' + this.minorProtocolVersion + "; oc=" + this.opCode + "; rc=" + this.responseCode + "; snId=" + this.sessionId + (this.certify ? " crt" : "") + (this.cacheCertify ? " caCrt" : "") + (this.authoritative ? " auth" : "") + (this.continuous ? " cont'd" : "") + (this.encrypt ? " encrypt" : "") + (this.ignoreRestrictedValues ? " noAuth" : "") + (this.overwriteWhenExists ? " overwriteWhenExists" : "") + (this.mintNewSuffix ? " mintNewSuffix" : "") + (this.doNotRefer ? " doNotRefer" : "") + (this.expiration != 0 ? " expires:" + new Date((long)this.expiration * 1000L) : "");
    }

    public static final String getResponseCodeMessage(int responseCode) {
        switch (responseCode) {
            case 0: {
                return "RC_RESERVED";
            }
            case 1: {
                return "SUCCESS";
            }
            case 2: {
                return "ERROR";
            }
            case 3: {
                return "SERVER TOO BUSY";
            }
            case 4: {
                return "PROTOCOL ERROR";
            }
            case 5: {
                return "OPERATION NOT SUPPORTED";
            }
            case 6: {
                return "RECURSION COUNT TOO HIGH";
            }
            case 100: {
                return "HANDLE NOT FOUND";
            }
            case 101: {
                return "HANDLE ALREADY EXISTS";
            }
            case 102: {
                return "INVALID HANDLE";
            }
            case 200: {
                return "VALUES NOT FOUND";
            }
            case 201: {
                return "VALUE ALREADY EXISTS";
            }
            case 202: {
                return "INVALID VALUE";
            }
            case 300: {
                return "OUT OF DATE SITE INFO";
            }
            case 301: {
                return "SERVER NOT RESPONSIBLE FOR HANDLE";
            }
            case 302: {
                return "SERVICE REFERRAL";
            }
            case 400: {
                return "INVALID ADMIN";
            }
            case 401: {
                return "INSUFFICIENT PERMISSIONS";
            }
            case 402: {
                return "AUTHENTICATION NEEDED";
            }
            case 403: {
                return "AUTHENTICATION FAILED";
            }
            case 404: {
                return "INVALID CREDENTIAL";
            }
            case 405: {
                return "AUTHENTICATION TIMEOUT";
            }
            case 406: {
                return "AUTHENTICATION ERROR";
            }
            case 500: {
                return "SESSION TIMEOUT";
            }
            case 501: {
                return "SESSION FAILED";
            }
            case 502: {
                return "INVALID SESSION KEY";
            }
            case 7: {
                return "SERVER BACKUP/MAINTAIN";
            }
            case 503: {
                return "REQUIRE RSA KEY FOR SESSION EXCHANGE";
            }
            case 504: {
                return "INVALID SESSION REQUEST";
            }
            case 505: {
                return "SESSION MESSAGE REJECTED";
            }
            case 303: {
                return "PREFIX REFERRAL";
            }
        }
        return "??";
    }
}

