/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import net.cnri.util.StreamTable;
import net.cnri.util.StreamVector;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.DumpHandlesCallback;
import net.handle.hdllib.DumpHandlesRequest;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ReplicationDaemonInterface;
import net.handle.hdllib.ScanCallback;
import net.handle.hdllib.SignedInputStream;
import net.handle.hdllib.SignedOutputStream;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.TransactionQueueInterface;
import net.handle.hdllib.Util;

public class DumpHandlesResponse
extends AbstractResponse {
    public DumpHandlesRequest req = null;
    private HandleStorage storage = null;
    private TransactionQueueInterface queue = null;
    private ReplicationDaemonInterface replicationDaemon;
    private byte lastProcessedRecordType = (byte)-2;
    private byte[] lastProcessedRecord = null;
    public static final byte THIS_SERVER_REPLICATION_INFO_RECORD = 0;
    public static final byte HANDLE_RECORD = 1;
    public static final byte HOMED_PREFIX_RECORD = 2;
    public static final byte HANDLE_DATE_RECORD = 3;
    public static final byte NA_DATE_RECORD = 4;
    public static final byte OTHER_SITE_REPLICATION_INFO_RECORD = 5;
    public static final byte ABSOLUTELY_DONE_RECORD = -1;

    public DumpHandlesResponse(DumpHandlesRequest req, HandleStorage storage, TransactionQueueInterface queue, ReplicationDaemonInterface replicationDaemon) throws HandleException {
        super(req, 1);
        this.req = req;
        this.storage = storage;
        this.queue = queue;
        this.replicationDaemon = replicationDaemon;
        this.streaming = true;
    }

    public DumpHandlesResponse() {
        super(1001, 1);
        this.streaming = true;
    }

    public byte getLastProcessedRecordType() {
        return this.lastProcessedRecordType;
    }

    public byte[] getLastProcessedRecord() {
        return this.lastProcessedRecord;
    }

    public void setLastProcessedRecordType(byte lastProcessedRecordType) {
        this.lastProcessedRecordType = lastProcessedRecordType;
    }

    public void setLastProcessedRecord(byte[] lastProcessedRecord) {
        this.lastProcessedRecord = lastProcessedRecord;
    }

    public void processStreamedPart(DumpHandlesCallback callback, PublicKey sourceKey) throws HandleException {
        if (this.stream == null) {
            throw new HandleException(1, "Response stream not found");
        }
        FilterInputStream in = null;
        FilterInputStream sin = null;
        try {
            boolean sawAbsolutelyDone;
            sin = new SignedInputStream(sourceKey, this.stream, this.socket);
            if (!this.secureStream && !((SignedInputStream)sin).isSecure()) {
                throw new HandleException(10, "Insecure stream");
            }
            in = new DataInputStream(sin);
            int dataVersion = ((DataInputStream)in).readInt();
            if (!((SignedInputStream)sin).verifyBlock()) {
                throw new HandleException(10, "Invalid signature on replication stream");
            }
            while (true) {
                int priority;
                byte[] naHandle;
                byte recordType;
                try {
                    recordType = ((DataInputStream)in).readByte();
                }
                catch (EOFException e) {
                    sawAbsolutelyDone = false;
                    break;
                }
                if (recordType == -1) {
                    sawAbsolutelyDone = true;
                    this.lastProcessedRecordType = (byte)-1;
                    break;
                }
                if (recordType == 0) {
                    long date = ((DataInputStream)in).readLong();
                    long txnId = ((DataInputStream)in).readLong();
                    if (!((SignedInputStream)sin).verifyBlock()) {
                        throw new HandleException(10, "Invalid signature on replication stream");
                    }
                    callback.processThisServerReplicationInfo(date, txnId);
                    this.lastProcessedRecordType = 0;
                    if (dataVersion < 2) {
                        return;
                    }
                } else if (recordType == 1) {
                    byte[] handleBytes = new byte[((DataInputStream)in).readInt()];
                    ((DataInputStream)in).readFully(handleBytes);
                    HandleValue[] values = new HandleValue[((DataInputStream)in).readInt()];
                    for (int i = 0; i < values.length; ++i) {
                        byte[] valueBytes = new byte[((DataInputStream)in).readInt()];
                        ((DataInputStream)in).readFully(valueBytes);
                        values[i] = new HandleValue();
                        Encoder.decodeHandleValue(valueBytes, 0, values[i]);
                    }
                    if (!((SignedInputStream)sin).verifyBlock()) {
                        throw new HandleException(10, "Invalid signature on replication stream");
                    }
                    callback.addHandle(handleBytes, values);
                    this.lastProcessedRecordType = 1;
                    this.lastProcessedRecord = handleBytes;
                } else if (recordType == 2) {
                    naHandle = new byte[((DataInputStream)in).readInt()];
                    ((DataInputStream)in).readFully(naHandle);
                    if (!((SignedInputStream)sin).verifyBlock()) {
                        throw new HandleException(10, "Invalid signature on replication stream");
                    }
                    callback.addHomedPrefix(naHandle);
                    this.lastProcessedRecordType = (byte)2;
                    this.lastProcessedRecord = naHandle;
                } else if (recordType == 3) {
                    byte[] handle = new byte[((DataInputStream)in).readInt()];
                    ((DataInputStream)in).readFully(handle);
                    long date = ((DataInputStream)in).readLong();
                    priority = ((DataInputStream)in).readInt();
                    if (!((SignedInputStream)sin).verifyBlock()) {
                        throw new HandleException(10, "Invalid signature on replication stream");
                    }
                    callback.setLastCreateOrDeleteDate(handle, date, priority);
                    this.lastProcessedRecordType = (byte)3;
                    this.lastProcessedRecord = handle;
                } else if (recordType == 4) {
                    naHandle = new byte[((DataInputStream)in).readInt()];
                    ((DataInputStream)in).readFully(naHandle);
                    long date = ((DataInputStream)in).readLong();
                    priority = ((DataInputStream)in).readInt();
                    if (!((SignedInputStream)sin).verifyBlock()) {
                        throw new HandleException(10, "Invalid signature on replication stream");
                    }
                    callback.setLastHomeOrUnhomeDate(naHandle, date, priority);
                    this.lastProcessedRecordType = (byte)4;
                    this.lastProcessedRecord = naHandle;
                } else if (recordType == 5) {
                    byte[] statusBytes = new byte[((DataInputStream)in).readInt()];
                    ((DataInputStream)in).readFully(statusBytes);
                    if (!((SignedInputStream)sin).verifyBlock()) {
                        throw new HandleException(10, "Invalid signature on replication stream");
                    }
                    StreamTable replicationConfig = new StreamTable();
                    replicationConfig.readFrom(Util.decodeString(statusBytes));
                    callback.processOtherSiteReplicationInfo(replicationConfig);
                    this.lastProcessedRecordType = (byte)5;
                } else {
                    throw new HandleException(0, "Unknown transmission record type: " + recordType);
                }
                Thread.yield();
            }
            if (!sawAbsolutelyDone) {
                System.err.println(">>> Dump stream ended unexpectedly");
                throw new HandleException(15, "Dump stream ended unexpectedly");
            }
        }
        catch (Exception e) {
            System.err.println(">>> Exception receiving dump: " + e);
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new HandleException(1, "Exception receiving handle dump", e);
        }
        finally {
            if (sin != null) {
                try {
                    sin.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void streamResponse(SignedOutputStream sout) throws HandleException {
        if (this.replicationDaemon != null) {
            this.replicationDaemon.pauseReplication();
        }
        try {
            DataOutputStream out = new DataOutputStream(sout);
            out.writeInt(2);
            sout.signBlock();
            if (this.req.startingPoint != null) {
                System.err.println("Resuming dump.");
                this.resumeDumpSendFromStartingPoint(sout, out);
            } else {
                if (this.replicationDaemon != null) {
                    StreamTable replicationStatus = this.replicationDaemon.replicationStatus();
                    replicationStatus = DumpHandlesResponse.omitEmptyQueues(replicationStatus);
                    byte[] statusBytes = Util.encodeString(replicationStatus.writeToString());
                    out.writeByte(5);
                    out.writeInt(statusBytes.length);
                    out.write(statusBytes);
                    sout.signBlock();
                }
                if (this.queue != null) {
                    long time = System.currentTimeMillis();
                    long txnId = this.queue.getLastTxnId();
                    out.writeByte(0);
                    out.writeLong(time);
                    out.writeLong(txnId);
                    sout.signBlock();
                }
                if (this.replicationDaemon != null) {
                    Iterator<byte[]> iter = this.replicationDaemon.handleIterator();
                    while (iter.hasNext()) {
                        out.writeByte(3);
                        out.write(iter.next());
                        sout.signBlock();
                    }
                    iter = this.replicationDaemon.naIterator();
                    while (iter.hasNext()) {
                        out.writeByte(4);
                        out.write(iter.next());
                        sout.signBlock();
                    }
                }
                this.storage.scanHandles(new HdlForwarder(out, sout, false));
                this.storage.scanNAs(new HdlForwarder(out, sout, true));
            }
            out.writeByte(-1);
        }
        catch (Exception e) {
            throw new HandleException(1, "Exception sending transactions: ", e);
        }
        finally {
            if (this.replicationDaemon != null) {
                this.replicationDaemon.unpauseReplication();
            }
        }
    }

    private static StreamTable omitEmptyQueues(StreamTable replicationStatus) {
        ArrayList<String> namesToDelete = new ArrayList<String>();
        Enumeration e = replicationStatus.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            StreamVector serverStates = (StreamVector)replicationStatus.get(name);
            boolean found = false;
            for (int i = 0; i < serverStates.size(); ++i) {
                StreamTable serverState = (StreamTable)serverStates.get(i);
                long lastTxnId = serverState.getLong("last_txn_id", -1L);
                if (lastTxnId < 0L) continue;
                found = true;
                break;
            }
            if (found) continue;
            namesToDelete.add(name);
        }
        for (String name : namesToDelete) {
            replicationStatus.remove(name);
        }
        return replicationStatus;
    }

    private void resumeDumpSendFromStartingPoint(SignedOutputStream sout, DataOutputStream out) throws IOException, SignatureException, HandleException {
        if (!this.storage.supportsDumpResumption()) {
            throw new HandleException(15, "Cannot resume dump from storage " + this.storage.getClass());
        }
        int startingPointType = this.req.startingPointType;
        if (startingPointType == 0) {
            if (this.replicationDaemon != null) {
                Iterator<byte[]> iter = this.replicationDaemon.handleIteratorFrom(this.req.startingPoint, false);
                while (iter.hasNext()) {
                    out.writeByte(3);
                    out.write(iter.next());
                    sout.signBlock();
                }
                iter = this.replicationDaemon.naIterator();
                while (iter.hasNext()) {
                    out.writeByte(4);
                    out.write(iter.next());
                    sout.signBlock();
                }
            }
            this.storage.scanHandles(new HdlForwarder(out, sout, false));
            this.storage.scanNAs(new HdlForwarder(out, sout, true));
        } else if (startingPointType == 1) {
            if (this.replicationDaemon != null) {
                Iterator<byte[]> iter = this.replicationDaemon.naIteratorFrom(this.req.startingPoint, false);
                while (iter.hasNext()) {
                    out.writeByte(4);
                    out.write(iter.next());
                    sout.signBlock();
                }
            }
            this.storage.scanHandles(new HdlForwarder(out, sout, false));
            this.storage.scanNAs(new HdlForwarder(out, sout, true));
        } else if (startingPointType == 2) {
            this.storage.scanHandlesFrom(this.req.startingPoint, false, new HdlForwarder(out, sout, false));
            this.storage.scanNAs(new HdlForwarder(out, sout, true));
        } else if (startingPointType == 3) {
            this.storage.scanNAsFrom(this.req.startingPoint, false, new HdlForwarder(out, sout, true));
        }
    }

    private class HdlForwarder
    implements ScanCallback {
        private final boolean scanningNAs;
        private final DataOutputStream out;
        private final SignedOutputStream sout;

        public HdlForwarder(DataOutputStream out, SignedOutputStream sout, boolean scanningNAs) {
            this.out = out;
            this.sout = sout;
            this.scanningNAs = scanningNAs;
        }

        @Override
        public void scanHandle(byte[] handle) throws HandleException {
            if (!this.scanningNAs && DumpHandlesResponse.this.req.serverNum != SiteInfo.determineServerNum(handle, DumpHandlesResponse.this.req.rcvrHashType, DumpHandlesResponse.this.req.numServers)) {
                return;
            }
            try {
                if (this.scanningNAs) {
                    this.out.write(2);
                    this.out.writeInt(handle.length);
                    this.out.write(handle);
                } else {
                    byte[][] values = DumpHandlesResponse.this.storage.getRawHandleValues(handle, null, null);
                    if (values == null) {
                        System.err.println("Unexpected null values for handle " + Util.decodeString(handle));
                        return;
                    }
                    this.out.write(1);
                    this.out.writeInt(handle.length);
                    this.out.write(handle);
                    this.out.writeInt(values.length);
                    for (byte[] value : values) {
                        this.out.writeInt(value.length);
                        this.out.write(value);
                    }
                }
                this.sout.signBlock();
            }
            catch (Exception e) {
                if (e instanceof HandleException) {
                    throw (HandleException)e;
                }
                throw new HandleException(1, (Throwable)e);
            }
        }
    }
}

