/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.Util;

public class HandleException
extends Exception {
    public static final int INVALID_VALUE = 0;
    public static final int INTERNAL_ERROR = 1;
    public static final int SERVICE_NOT_FOUND = 2;
    public static final int NO_ACCEPTABLE_INTERFACES = 3;
    public static final int UNKNOWN_PROTOCOL = 4;
    public static final int HANDLE_ALREADY_EXISTS = 5;
    public static final int MESSAGE_FORMAT_ERROR = 6;
    public static final int CANNOT_CONNECT_TO_SERVER = 7;
    public static final int UNABLE_TO_AUTHENTICATE = 8;
    public static final int HANDLE_DOES_NOT_EXIST = 9;
    public static final int SECURITY_ALERT = 10;
    public static final int CONFIGURATION_ERROR = 11;
    public static final int REPLICATION_ERROR = 12;
    public static final int MISSING_OR_INVALID_SIGNATURE = 13;
    public static final int MISSING_CRYPTO_PROVIDER = 14;
    public static final int SERVER_ERROR = 15;
    public static final int UNKNOWN_ALGORITHM_ID = 16;
    public static final int GOT_EXPIRED_MESSAGE = 17;
    public static final int STORAGE_RDONLY = 18;
    public static final int UNABLE_TO_SIGN_REQUEST = 19;
    public static final int INVALID_SESSION_EXCHANGE_PRIVKEY = 20;
    public static final int NEED_RSAKEY_FOR_SESSIONEXCHANGE = 21;
    public static final int NEED_PUBLICKEY_FOR_SESSIONIDENTITY = 22;
    public static final int SESSION_TIMEOUT = 23;
    public static final int INCOMPLETE_SESSIONSETUP = 24;
    public static final int SERVER_CANNOT_PROCESS_SESSION = 25;
    public static final int ENCRYPTION_ERROR = 26;
    public static final int OTHER_CONNECTION_ESTABLISHED = 27;
    public static final int DUPLICATE_SESSION_COUNTER = 28;
    public static final int SERVICE_REFERRAL_ERROR = 29;
    public static final String OTHER_CONNECTION_ESTABLISHED_STRING = "This request has been fully processed by another thread.";
    private final int code;

    public static final String getCodeStr(int c) {
        switch (c) {
            case 0: {
                return "INVALID_VALUE";
            }
            case 1: {
                return "INTERNAL_ERROR";
            }
            case 2: {
                return "SERVICE_NOT_FOUND";
            }
            case 3: {
                return "NO_ACCEPTABLE_INTERFACES";
            }
            case 4: {
                return "UNKNOWN_PROTOCOL";
            }
            case 5: {
                return "HANDLE_ALREADY_EXISTS";
            }
            case 6: {
                return "MESSAGE_FORMAT_ERROR";
            }
            case 7: {
                return "CANNOT_CONNECT_TO_SERVER";
            }
            case 8: {
                return "UNABLE_TO_AUTHENTICATE";
            }
            case 9: {
                return "HANDLE_DOES_NOT_EXIST";
            }
            case 10: {
                return "SECURITY_ALERT";
            }
            case 11: {
                return "CONFIGURATION_ERROR";
            }
            case 12: {
                return "REPLICATION_ERROR";
            }
            case 16: {
                return "UNKNOWN_ALGORITHM_ID";
            }
            case 13: {
                return "MISSING_OR_INVALID_SIGNATURE";
            }
            case 14: {
                return "MISSING_CRYPTO_PROVIDER";
            }
            case 15: {
                return "SERVER_ERROR";
            }
            case 17: {
                return "GOT_EXPIRED_MESSAGE";
            }
            case 18: {
                return "STORAGE_RDONLY";
            }
            case 19: {
                return "UNABLE_TO_SIGN_REQUEST";
            }
            case 20: {
                return "INVALID_SESSION_EXCHANGE_PRIVKEY";
            }
            case 21: {
                return "NEED_RSAKEY_FOR_SESSIONEXCHANGE";
            }
            case 22: {
                return "NEED_PUBLICKEY_FOR_SESSIONIDENTITY";
            }
            case 23: {
                return "SESSION_TIMEOUT";
            }
            case 24: {
                return "INCOMPLETE_SESSIONSETUP";
            }
            case 25: {
                return "SERVER_CANNOT_PROCESS_SESSION";
            }
            case 26: {
                return "ENCRYPTION_ERROR";
            }
            case 27: {
                return "OTHER_CONNECTION_ESTABLISHED";
            }
            case 28: {
                return "DUPLICATE_SESSION_COUNTER";
            }
            case 29: {
                return "SERVICE_REFERRAL_ERROR";
            }
        }
        return "UNKNOWN_ERROR(" + c + ")";
    }

    public HandleException(int code) {
        this.code = code;
    }

    public HandleException(int code, String message) {
        super(message);
        this.code = code;
    }

    public HandleException(int code, Throwable throwable) {
        super(throwable);
        this.code = code;
    }

    public HandleException(int code, String message, Throwable throwable) {
        super(message, throwable);
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public String toString() {
        String msg = this.getMessage();
        if (msg == null) {
            msg = "";
        }
        return "HandleException (" + HandleException.getCodeStr(this.code) + ") " + msg;
    }

    private static final int responseCodeFromExceptionCodeThrownByResolver(int c) {
        switch (c) {
            case 2: {
                return 100;
            }
            case 8: {
                return 406;
            }
            case 9: {
                return 100;
            }
        }
        return 2;
    }

    public ErrorResponse toErrorResponse(AbstractRequest req) {
        try {
            if (req != null) {
                return new ErrorResponse(req, HandleException.responseCodeFromExceptionCodeThrownByResolver(this.code), Util.encodeString(this.toString()));
            }
        }
        catch (HandleException handleException) {
            // empty catch block
        }
        return new ErrorResponse(0, HandleException.responseCodeFromExceptionCodeThrownByResolver(this.code), Util.encodeString(this.toString()));
    }

    public static ErrorResponse toErrorResponse(AbstractRequest req, Exception e) {
        if (e instanceof HandleException) {
            return ((HandleException)e).toErrorResponse(req);
        }
        try {
            if (req != null) {
                return new ErrorResponse(req, 2, Util.encodeString(e.toString()));
            }
        }
        catch (HandleException handleException) {
            // empty catch block
        }
        return new ErrorResponse(0, 2, Util.encodeString(e.toString()));
    }

    public static HandleException ofResponse(AbstractResponse response) {
        switch (response.responseCode) {
            case 1: 
            case 302: 
            case 303: 
            case 402: {
                return new HandleException(1, "Unexpected response: " + response.toString());
            }
            case 4: {
                return new HandleException(6, response.toString());
            }
            case 100: {
                return new HandleException(9, response.toString());
            }
            case 101: {
                return new HandleException(5, response.toString());
            }
            case 102: 
            case 200: 
            case 201: 
            case 202: {
                return new HandleException(0, response.toString());
            }
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: {
                return new HandleException(8, response.toString());
            }
            case 500: {
                return new HandleException(23, response.toString());
            }
            case 501: 
            case 502: 
            case 503: 
            case 504: {
                return new HandleException(25, response.toString());
            }
            case 505: {
                return new HandleException(28, response.toString());
            }
        }
        return new HandleException(15, response.toString());
    }
}

