/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.StringReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.cnri.simplexml.XParser;
import net.cnri.simplexml.XTag;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;

@Deprecated
public class HandleSignature {
    public static final byte[] METADATA_TYPE = Util.encodeString("10320/sig.digest");
    public static final byte[] SIGNATURE_TYPE = Util.encodeString("10320/sig.sig");
    final HandleValue digestsValue;
    final DigestsValue parsedDigestsValue;
    final String algorithm;
    final ValueReference signer;
    final byte[] signature;
    public static final int VALUE_DIGEST_OFFSET = 8;
    private static ConcurrentMap<String, MessageDigest> digests = new ConcurrentHashMap<String, MessageDigest>();

    public HandleSignature(HandleValue digestsValue, DigestsValue parsedDigestValue, String algorithm, ValueReference signer, byte[] signature) throws Exception {
        this.digestsValue = digestsValue;
        this.parsedDigestsValue = parsedDigestValue;
        this.algorithm = algorithm;
        this.signer = signer;
        this.signature = signature;
    }

    public String getHandle() {
        return this.parsedDigestsValue.getHandle();
    }

    public HandleValue getDigestsValue() {
        return this.digestsValue;
    }

    public DigestsValue getParsedDigestsValue() {
        return this.parsedDigestsValue;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public ValueReference getSigner() {
        return this.signer;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public String toString() {
        return "HandleSignature [digestsValue=" + this.digestsValue + ", algorithm=" + this.algorithm + ", signer=" + this.signer + "]";
    }

    public static void updateForHandleValue(MessageDigest digest, byte[] encodedHandleValue) {
        digest.update(encodedHandleValue, 8, encodedHandleValue.length - 8);
    }

    public static void updateForHandleValue(Signature sig, byte[] encodedHandleValue) throws SignatureException {
        sig.update(encodedHandleValue, 8, encodedHandleValue.length - 8);
    }

    public boolean verifySignature(PublicKey pubKey) throws Exception {
        String alg = this.algorithm;
        if (alg == null) {
            alg = Util.getSigIdFromHashAlgId(Common.HASH_ALG_SHA1, pubKey.getAlgorithm());
        }
        Signature sig = Signature.getInstance(alg);
        sig.initVerify(pubKey);
        HandleSignature.updateForHandleValue(sig, Encoder.encodeHandleValue(this.digestsValue));
        return sig.verify(this.signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyValue(String handle, HandleValue value) throws NoSuchAlgorithmException {
        if (!Util.equalsPrefixCI(handle, this.getHandle())) {
            return false;
        }
        List<Digest> digests = this.parsedDigestsValue.getDigests().get(value.getIndex());
        if (digests == null) {
            return false;
        }
        byte[] encodedHandleValue = Encoder.encodeHandleValue(value);
        boolean foundSha = false;
        for (Digest digest : digests) {
            byte[] checkDigest;
            MessageDigest messageDigest;
            MessageDigest messageDigest2 = messageDigest = HandleSignature.getMessageDigest(digest.getAlgorithm());
            synchronized (messageDigest2) {
                messageDigest.reset();
                HandleSignature.updateForHandleValue(messageDigest, encodedHandleValue);
                checkDigest = messageDigest.digest();
            }
            if (!Util.equals(checkDigest, digest.getDigest())) {
                return false;
            }
            if (!digest.getAlgorithm().toLowerCase().startsWith("sha")) continue;
            foundSha = true;
        }
        return foundSha;
    }

    public boolean signsMissingValues(HandleValue[] values) {
        ArrayList<Integer> signedIndices = new ArrayList<Integer>(this.parsedDigestsValue.getDigests().keySet());
        for (HandleValue value : values) {
            signedIndices.remove((Object)value.getIndex());
        }
        return !signedIndices.isEmpty();
    }

    private static MessageDigest getMessageDigest(String algorithm) throws NoSuchAlgorithmException {
        MessageDigest res = (MessageDigest)digests.get(algorithm);
        if (res != null) {
            return res;
        }
        MessageDigest newDigest = MessageDigest.getInstance(algorithm);
        digests.putIfAbsent(algorithm, newDigest);
        return newDigest;
    }

    public static List<HandleSignature> getSignatures(HandleValue[] values, HandleValue value, boolean throwOnError) throws Exception {
        try {
            if (!value.hasType(SIGNATURE_TYPE)) {
                return null;
            }
            XParser parser = new XParser();
            XTag root = parser.parse(new StringReader(value.getDataAsString()), false);
            String defaultSigner = root.getAttribute("signer");
            String defaultSignerIndex = root.getAttribute("signerIndex", "300");
            String ofIndex = root.getAttribute("ofIndex", root.getAttribute("ofindex"));
            String handle = root.getAttribute("hdl");
            HandleValue digestsValue = HandleSignature.getValueOfIndex(values, ofIndex);
            if (digestsValue == null) {
                throw new Exception("Unable to find digests value for signature value " + root);
            }
            DigestsValue parsedDigestValue = DigestsValue.ofXml(digestsValue.getDataAsString());
            if (handle != null && !Util.equalsPrefixCI(handle, parsedDigestValue.getHandle())) {
                throw new Exception("Handle does not match in signature and digests value " + root);
            }
            ArrayList<HandleSignature> res = new ArrayList<HandleSignature>();
            for (XTag child : root.getSubTags()) {
                try {
                    res.add(HandleSignature.getHandleSignature(child, digestsValue, parsedDigestValue, defaultSigner, defaultSignerIndex));
                }
                catch (Exception e) {
                    if (!throwOnError) continue;
                    throw e;
                }
            }
            return res;
        }
        catch (Exception e) {
            if (throwOnError) {
                throw e;
            }
            return null;
        }
    }

    public static List<HandleSignature> getSignaturesQuietly(HandleValue[] values) {
        try {
            return HandleSignature.getSignatures(values, false);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static List<HandleSignature> getSignatures(HandleValue[] values, boolean throwOnError) throws Exception {
        ArrayList<HandleSignature> res = new ArrayList<HandleSignature>();
        for (HandleValue value : values) {
            List<HandleSignature> sublist = HandleSignature.getSignatures(values, value, throwOnError);
            if (sublist == null) continue;
            res.addAll(sublist);
        }
        return res;
    }

    private static HandleValue getValueOfIndex(HandleValue[] values, String ofIndex) {
        HandleValue digestsValue = null;
        for (HandleValue candidate : values) {
            if (!String.valueOf(candidate.getIndex()).equals(ofIndex)) continue;
            digestsValue = candidate;
            break;
        }
        return digestsValue;
    }

    private static HandleSignature getHandleSignature(XTag child, HandleValue digestsValue, DigestsValue parsedDigestValue, String defaultSigner, String defaultSignerIndex) throws Exception {
        ValueReference signerRef;
        String algorithm = child.getAttribute("alg");
        String signer = child.getAttribute("signer", defaultSigner);
        String signerIndex = child.getAttribute("signerIndex", defaultSignerIndex);
        String signatureHex = child.getStrValue();
        try {
            signerRef = new ValueReference(Util.encodeString(signer), Integer.parseInt(signerIndex));
        }
        catch (NumberFormatException e) {
            throw new Exception("Invalid signer index " + signerIndex + " in " + child, e);
        }
        return new HandleSignature(digestsValue, parsedDigestValue, algorithm, signerRef, Util.encodeHexString(signatureHex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HandleValue createDigestsValue(int index, String handle, HandleValue[] values) {
        XTag root = new XTag("digests");
        root.setAttribute("hdl", handle);
        for (HandleValue value : values) {
            XTag child = new XTag("val");
            child.setAttribute("index", value.getIndex());
            byte[] encodedHandleValue = Encoder.encodeHandleValue(value);
            for (String alg : new String[]{"md5", "sha1"}) {
                byte[] digest;
                MessageDigest messageDigest;
                try {
                    messageDigest = HandleSignature.getMessageDigest(alg);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new AssertionError((Object)e);
                }
                MessageDigest messageDigest2 = messageDigest;
                synchronized (messageDigest2) {
                    messageDigest.reset();
                    HandleSignature.updateForHandleValue(messageDigest, encodedHandleValue);
                    digest = messageDigest.digest();
                }
                child.setAttribute(alg, Util.decodeHexString(digest, false));
            }
            root.addSubTag(child);
        }
        return new HandleValue(index, METADATA_TYPE, Util.encodeString(root.toString()));
    }

    public static HandleValue createSignatureValue(int index, String handle, ValueReference signer, String alg, PrivateKey privKey, HandleValue digestsValue) throws Exception {
        XTag root = new XTag("signature");
        if (handle != null) {
            root.setAttribute("hdl", handle);
        }
        root.setAttribute("ofindex", digestsValue.getIndex());
        root.setAttribute("signer", Util.decodeString(signer.handle));
        root.setAttribute("signerIndex", signer.index);
        if (alg == null) {
            alg = Util.getDefaultSigId(privKey.getAlgorithm());
        }
        XTag child = new XTag("sig");
        child.setAttribute("alg", alg);
        child.setAttribute("signer", Util.decodeString(signer.handle));
        child.setAttribute("signerIndex", signer.index);
        Signature sig = Signature.getInstance(alg);
        sig.initSign(privKey);
        HandleSignature.updateForHandleValue(sig, Encoder.encodeHandleValue(digestsValue));
        byte[] signature = sig.sign();
        child.setValue(Util.decodeHexString(signature, false));
        root.addSubTag(child);
        return new HandleValue(index, SIGNATURE_TYPE, Util.encodeString(root.toString()));
    }

    public static HandleValue[] signedHandleValues(String handle, HandleValue[] values, HandleSignature signature, PublicKey pubKey, boolean throwOnError) throws Exception {
        if (!Util.equalsPrefixCI(handle, signature.getHandle())) {
            return new HandleValue[0];
        }
        try {
            if (!signature.verifySignature(pubKey)) {
                return new HandleValue[0];
            }
        }
        catch (Exception e) {
            if (throwOnError) {
                throw e;
            }
            return new HandleValue[0];
        }
        ArrayList<HandleValue> res = new ArrayList<HandleValue>();
        for (HandleValue value : values) {
            try {
                if (!signature.verifyValue(handle, value)) continue;
                res.add(value);
            }
            catch (Exception e) {
                if (!throwOnError) continue;
                throw e;
            }
        }
        return res.toArray(new HandleValue[res.size()]);
    }

    public static boolean signsAllValues(String handle, HandleValue[] values, HandleSignature signature, PublicKey pubKey, boolean throwOnError) throws Exception {
        if (!Util.equalsPrefixCI(handle, signature.getHandle())) {
            return false;
        }
        try {
            if (!signature.verifySignature(pubKey)) {
                return false;
            }
        }
        catch (Exception e) {
            if (throwOnError) {
                throw e;
            }
            return false;
        }
        for (HandleValue value : values) {
            try {
                if (!HandleSignature.valueNeedsSignature(value) || signature.verifyValue(handle, value)) continue;
                return false;
            }
            catch (Exception e) {
                if (!throwOnError) continue;
                throw e;
            }
        }
        return true;
    }

    public static boolean valueNeedsSignature(HandleValue value) {
        return !value.hasType(SIGNATURE_TYPE) && !value.hasType(METADATA_TYPE) && value.publicRead;
    }

    public static class DigestsValue {
        final String handle;
        final Map<Integer, List<Digest>> digests;

        public DigestsValue(String handle, Map<Integer, List<Digest>> digests) {
            this.handle = handle;
            this.digests = digests;
        }

        public String getHandle() {
            return this.handle;
        }

        public Map<Integer, List<Digest>> getDigests() {
            return this.digests;
        }

        public static DigestsValue ofXml(String xml) throws Exception {
            XParser parser = new XParser();
            XTag root = parser.parse(new StringReader(xml), false);
            String handle = root.getAttribute("hdl");
            HashMap<Integer, List<Digest>> digests = new HashMap<Integer, List<Digest>>();
            if (root.getSubTags() != null) {
                for (XTag child : root.getSubTags()) {
                    int index;
                    try {
                        index = Integer.parseInt(child.getAttribute("index"));
                    }
                    catch (Exception e) {
                        throw new Exception("bad index attribute " + child, e);
                    }
                    ArrayList<Digest> digestList = new ArrayList<Digest>();
                    for (Map.Entry<String, String> entry : child.getAttributes().entrySet()) {
                        String name = entry.getKey();
                        if ("index".equals(name)) continue;
                        digestList.add(new Digest(name, Util.encodeHexString(entry.getValue())));
                    }
                    if (digests.containsKey(index)) {
                        throw new Exception("duplicate index attribute " + child);
                    }
                    digests.put(index, digestList);
                }
            }
            return new DigestsValue(handle, digests);
        }
    }

    public static class Digest {
        final String algorithm;
        final byte[] digest;

        public Digest(String algorithm, byte[] digest) {
            this.algorithm = algorithm;
            this.digest = digest;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public byte[] getDigest() {
            return this.digest;
        }
    }
}

