/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.security.PublicKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.Configuration;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleSignature;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;

@Deprecated
public class SecureResolver {
    public static final String SIGNED_INDEX_TAGNAME = "ofindex";
    public static final String SIG_ALG_TAGNAME = "alg";
    public static final String SIG_TAGNAME = "sig";
    public static final String DEFAULT_ALGORITHM = "DSA";
    public static final String VALUE_HASH_ELEMENT_NAME = "val";
    public static final String VALUE_INDEX_ATTRIBUTE = "index";
    public static final String SIG_HANDLE_ATTRIBUTE = "hdl";
    public static final String SIGNER_HANDLE_ATTRIBUTE = "signer";
    public static final String SIGNER_INDEX_ATTRIBUTE = "signerIndex";
    public static final String VALUE_MD5HASH_ATTRIBUTE = "md5";
    public static final String VALUE_SHA1HASH_ATTRIBUTE = "sha1";
    public static final int VALUE_DIGEST_OFFSET = 8;
    public static final byte[] METADATA_TYPE = Util.encodeString("10320/sig.digest");
    public static final byte[] SIGNATURE_TYPE = Util.encodeString("10320/sig.sig");
    private final HandleResolver resolver;
    private boolean trustNamespaceKeys = true;
    private volatile Map<ValueReference, PublicKey> trustedKeys = new HashMap<ValueReference, PublicKey>();
    public boolean ignoreUnsignedValues = true;
    public boolean reportMissingValues = false;
    public boolean ignoreInvalidSignatures = false;
    public boolean traceMessages = false;

    public SecureResolver() {
        this(new HandleResolver());
    }

    public SecureResolver(HandleResolver resolver) {
        this.resolver = resolver;
        this.setRootKeysAsTrusted();
    }

    public void printState() {
        if (this.traceMessages) {
            System.err.println("trusted keys: " + this.trustedKeys);
            System.err.println("  trustNSKeys: " + this.trustNamespaceKeys);
            System.err.println("  ignoreUnsignedValues: " + this.ignoreUnsignedValues);
            System.err.println("  reportMissingValues: " + this.reportMissingValues);
            System.err.println("  ignoreInvalidSignatures: " + this.ignoreInvalidSignatures);
        }
    }

    public void setRootKeysAsTrusted() {
        Configuration conf = this.resolver.getConfiguration();
        HashMap<ValueReference, PublicKey> pubkeys = new HashMap<ValueReference, PublicKey>();
        for (HandleValue rootVal : conf.getGlobalValues()) {
            if (!rootVal.hasType(Common.STD_TYPE_HSPUBKEY)) continue;
            try {
                pubkeys.put(new ValueReference(Common.ROOT_HANDLE, rootVal.getIndex()), Util.getPublicKeyFromBytes(rootVal.getData(), 0));
            }
            catch (Exception e) {
                System.err.println("Warning: error parsing root service public key: " + e);
            }
        }
        if (this.traceMessages) {
            System.err.println("putting trusted root keys: " + pubkeys);
        }
        this.setTrustedKeys(pubkeys);
    }

    public void setTrustedKeys(Map<ValueReference, PublicKey> keyIDsMap) {
        HashMap<ValueReference, PublicKey> newMap = new HashMap<ValueReference, PublicKey>();
        for (Map.Entry<ValueReference, PublicKey> entry : keyIDsMap.entrySet()) {
            newMap.put(new ValueReference((byte[])entry.getKey().handle.clone(), entry.getKey().index), entry.getValue());
        }
        this.trustedKeys = newMap;
    }

    public PublicKey getTrustedKey(ValueReference valRef) {
        return this.trustedKeys.get(valRef);
    }

    public void setTrustNamespaceKeys(boolean trustThem) {
        this.trustNamespaceKeys = trustThem;
    }

    public HandleValue[] resolveHandle(byte[] handle, byte[][] types, int[] indexes) throws HandleException {
        return this.resolveHandle(new ResolutionRequest(handle, types, indexes, null));
    }

    public HandleValue[] resolveHandle(ResolutionRequest req) throws HandleException {
        Object types;
        byte[][] origTypes = types = req.requestedTypes;
        int[] indexes = req.requestedIndexes;
        if (types != null && ((byte[][])types).length > 0 || indexes != null && indexes.length > 0) {
            if (types == null) {
                types = new byte[][]{METADATA_TYPE, SIGNATURE_TYPE};
            } else {
                byte[][] newTypes = new byte[2 + ((byte[][])types).length][];
                newTypes[0] = METADATA_TYPE;
                newTypes[1] = SIGNATURE_TYPE;
                System.arraycopy(types, 0, newTypes, 2, ((byte[][])types).length);
                types = newTypes;
            }
            req.requestedTypes = types;
            req.requestedIndexes = indexes;
            req.clearBuffers();
        }
        HandleValue[] values = null;
        AbstractResponse resp = this.resolver.processRequest(req);
        if (!(resp instanceof ResolutionResponse)) {
            if (resp.responseCode == 100) {
                throw new HandleException(9);
            }
            if (resp instanceof ErrorResponse) {
                String msg = Util.decodeString(((ErrorResponse)resp).message);
                throw new HandleException(1, "Error(" + resp.responseCode + "): " + msg);
            }
            throw new HandleException(1, "Unknown response: " + resp);
        }
        values = ((ResolutionResponse)resp).getHandleValues();
        int numSigs = 0;
        int numMetadata = 0;
        for (int i = 0; values != null && i < values.length; ++i) {
            if (values[i] == null) continue;
            if (values[i].hasType(SIGNATURE_TYPE)) {
                ++numSigs;
            }
            if (!values[i].hasType(METADATA_TYPE)) continue;
            ++numMetadata;
        }
        if (numSigs == 0 && numMetadata == 0) {
            if (this.ignoreUnsignedValues) {
                return new HandleValue[0];
            }
            throw new HandleException(0, "No signatures found in " + Util.decodeString(req.handle));
        }
        try {
            Map<ValueReference, PublicKey> keys = this.trustedKeys;
            if (this.trustNamespaceKeys) {
                HashMap<ValueReference, PublicKey> localKeys = new HashMap<ValueReference, PublicKey>();
                localKeys.putAll(this.trustedKeys);
                this.addKeysFromHandle(Util.getZeroNAHandle(req.handle), localKeys);
                keys = localKeys;
            }
            return this.secureHandleValues(req.handle, values, keys, origTypes, indexes);
        }
        catch (Exception e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new HandleException(26, "Error verifying signature: " + e);
        }
    }

    public HandleValue[] secureHandleValues(byte[] handle, HandleValue[] values) throws Exception {
        return this.secureHandleValues(handle, values, this.trustedKeys);
    }

    public HandleValue[] secureHandleValues(byte[] handle, HandleValue[] aValues, Map<ValueReference, PublicKey> keys) throws Exception {
        return this.secureHandleValues(handle, aValues, keys, null, null);
    }

    private HandleValue[] secureHandleValues(byte[] handle, HandleValue[] aValues, Map<ValueReference, PublicKey> keys, byte[][] types, int[] indexes) throws Exception {
        int i;
        HandleValue[] values = new HandleValue[aValues.length];
        System.arraycopy(aValues, 0, values, 0, aValues.length);
        List<HandleSignature> sigList = HandleSignature.getSignatures(values, !this.ignoreInvalidSignatures);
        Iterator<HandleSignature> sigIter = sigList.iterator();
        while (sigIter.hasNext()) {
            HandleSignature sig = sigIter.next();
            PublicKey signerKey = keys.get(sig.getSigner());
            if (signerKey == null) {
                if (this.traceMessages || this.resolver.traceMessages) {
                    System.err.println("ignoring signature: " + sig.getSigner());
                }
                sigIter.remove();
                continue;
            }
            if (!Util.equalsPrefixCI(handle, Util.encodeString(sig.getHandle()))) {
                if (this.ignoreInvalidSignatures) {
                    sigIter.remove();
                    continue;
                }
                throw new HandleException(26, "Signature for wrong handle encountered: " + sig);
            }
            if (!sig.verifySignature(signerKey)) {
                if (this.traceMessages || this.resolver.traceMessages) {
                    System.err.println("verify-signature failed: " + sig);
                }
                if (this.ignoreInvalidSignatures) {
                    sigIter.remove();
                    continue;
                }
                throw new HandleException(26, "Invalid signature encountered: " + sig);
            }
            if (!this.reportMissingValues || !sig.signsMissingValues(values)) continue;
            throw new HandleException(26, "Signature signs missing values: " + sig);
        }
        int numVals = 0;
        for (i = 0; i < values.length; ++i) {
            HandleValue value = values[i];
            if (value == null) continue;
            if (!SecureResolver.valueNeedsSignature(value)) {
                ++numVals;
                continue;
            }
            boolean isSigned = false;
            String handleString = Util.decodeString(handle);
            for (HandleSignature sig : sigList) {
                if (!sig.verifyValue(handleString, value)) continue;
                isSigned = true;
                break;
            }
            if (isSigned) {
                ++numVals;
                continue;
            }
            if (this.ignoreUnsignedValues) {
                values[i] = null;
                continue;
            }
            throw new HandleException(26, "Encountered unsigned value: " + value);
        }
        if (types != null && types.length > 0 || indexes != null && indexes.length > 0) {
            for (i = 0; i < values.length; ++i) {
                if (values[i] == null || types != null && types.length > 0 && Util.isParentTypeInArray(types, values[i].type) || indexes != null && indexes.length > 0 && Util.isInArray(indexes, values[i].index)) continue;
                values[i] = null;
                --numVals;
            }
        }
        HandleValue[] returnVals = new HandleValue[numVals];
        for (int i2 = values.length - 1; i2 >= 0; --i2) {
            if (values[i2] == null) continue;
            returnVals[--numVals] = values[i2];
        }
        return returnVals;
    }

    private void addKeysFromHandle(byte[] trustedHandle, Map<ValueReference, PublicKey> trustedKeys) throws Exception {
        HandleValue[] values = null;
        values = Util.equalsCI(trustedHandle, Common.ROOT_HANDLE) ? this.resolver.getConfiguration().getGlobalValues() : this.resolveHandle(trustedHandle, new byte[][]{Common.STD_TYPE_HSPUBKEY}, null);
        for (int i = 0; values != null && i < values.length; ++i) {
            if (!values[i].hasType(Common.STD_TYPE_HSPUBKEY)) continue;
            try {
                trustedKeys.put(new ValueReference(trustedHandle, values[i].getIndex()), Util.getPublicKeyFromBytes(values[i].getData(), 0));
                continue;
            }
            catch (Exception e) {
                System.err.println("Error loading namespace key: " + e);
            }
        }
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length <= 0) {
            System.err.println("usage: java net.handle.hdllib.SecureResolver <handle1> [<handle2>...]");
            return;
        }
        SecureResolver r = new SecureResolver();
        for (String hdl : argv) {
            HandleValue[] values;
            System.out.println("Resolving " + hdl);
            for (HandleValue val : values = r.resolveHandle(Util.encodeString(hdl), null, null)) {
                System.out.println("  " + val);
            }
        }
    }

    public static boolean valueNeedsSignature(HandleValue value) {
        return !value.hasType(SIGNATURE_TYPE) && !value.hasType(METADATA_TYPE) && value.publicRead;
    }
}

